/* $Id: RectObj.C,v 1.1.1.1 1997/03/19 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/RectObj.h>

/* RectObjClass Members */

Boolean
_RectObjClass::ancestorSensitive() 
{
   Boolean cond;
   XtVaGetValues(widget(), XmNancestorSensitive, &cond, NULL);
   return cond;
}

Dimension
_RectObjClass::borderWidth() 
{
   Dimension w; 
   XtVaGetValues(widget(), XmNborderWidth, &w, NULL); 
   return w;
}

void 
_RectObjClass::borderWidth(Dimension w) 
{
   XtVaSetValues(widget(),XmNborderWidth,w,NULL);
}

void 
_RectObjClass::sensitive(Boolean cond) 
{
   XtSetSensitive(widget(),cond);
}

Boolean 
_RectObjClass::sensitive() 
{
   return XtIsSensitive(widget());
}

Dimension 
_RectObjClass::width() 
{ 
   Dimension w; 
   XtVaGetValues(widget(), XmNwidth, &w, NULL); 
   return w; 
}

void
_RectObjClass::width(Dimension w) 
{ 
   XtVaSetValues(widget(), XmNwidth, w, NULL); 
}

Dimension 
_RectObjClass::height() 
{
   Dimension h; 
   XtVaGetValues(widget(), XmNheight, &h, NULL);
   return h;
}

void
_RectObjClass::height(Dimension h) 
{
   XtVaSetValues(widget(), XmNheight, h, NULL);
}

Position 
_RectObjClass::x() 
{
   Position xpos;
   XtVaGetValues(widget(),XmNx,&xpos, NULL);
   return xpos;
}

void
_RectObjClass::x(Position xpos) 
{
   XtVaSetValues(widget(),XmNx,xpos, NULL);
}

Position 
_RectObjClass::y() 
{
   Position ypos;
   XtVaGetValues(widget(),XmNy,&ypos,NULL);
   return ypos;
}

void
_RectObjClass::y(Position ypos) 
{
   XtVaSetValues(widget(),XmNy,ypos,NULL);
}

