/* $Id: Registry.C,v 1.1.1.1 1997/03/19 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994-1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s) */
#include <Xarm/Registry.h>

/* Drop site members */
void 
DropSiteClass::dragProc(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdragProc,fp,udata);
}

void 
DropSiteClass::dropProc(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdropProc,fp,udata);
}

/* convenience routines */
void 
DropSiteClass::configureStackingOrder(Widget sibling, Cardinal stack_mode)
{
   XmDropSiteConfigureStackingOrder(widget(), sibling, stack_mode);
}

void 
DropSiteClass::endUpdate()
{
   XmDropSiteEndUpdate(widget());
}

Status 
DropSiteClass::queryStackingOrder(Widget *w_parent_ret, 
                             Widget **children_ret, 
                             Cardinal *num_children_ret)
{
   return XmDropSiteQueryStackingOrder(widget(), 
                                       w_parent_ret,   
                                       children_ret, 
                                       num_children_ret);
}

void
DropSiteClass::Register(ArgList arglist, Cardinal cnt)
{
   XmDropSiteRegister(widget(),arglist, cnt);
}

void
DropSiteClass::retrieve(ArgList arglist, Cardinal cnt)
{
   XmDropSiteRetrieve(widget(),arglist, cnt);
}

void 
DropSiteClass::startUpdate()
{
   XmDropSiteStartUpdate(widget());
}
   
void
DropSiteClass::update(ArgList arglist, Cardinal cnt)
{
   XmDropSiteUpdate(widget(),arglist, cnt);
}

void
DropSiteClass::unregister()
{
   XmDropSiteUnregister(widget());
}

/* resources */
void 
DropSiteClass::animationMask(Pixmap p)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0], (_XtString) XmNanimationMask, (XtArgVal) p);

   XmDropSiteUpdate(widget(),arglist, argcount);
}

Pixmap 
DropSiteClass::animationMask()
{
   Pixmap p;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0], (_XtString) XmNanimationMask, (XtArgVal) &p);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return p;
}

void 
DropSiteClass::animationPixmap(Pixmap p)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0], (_XtString) XmNanimationPixmap, (XtArgVal) p);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Pixmap 
DropSiteClass::animationPixmap()
{
   Pixmap p;
   Cardinal argcount = 1;
   Arg arglist[1];

   XtSetArg(arglist[0], (_XtString) XmNanimationPixmap, (XtArgVal) &p); 

   XmDropSiteRetrieve(widget(),arglist, argcount);
   return p;
}

void 
DropSiteClass::animationPixmapDepth(int i)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNanimationPixmapDepth, (XtArgVal) i);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

int 
DropSiteClass::animationPixmapDepth()
{
   int i;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNanimationPixmapDepth, (XtArgVal) &i);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return i;
}

void 
DropSiteClass::animationStyle(unsigned char c)
{
   Arg arglist[1]; 
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNanimationStyle, (XtArgVal) c);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

unsigned char 
DropSiteClass::animationStyle()
{
   unsigned char c;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNanimationStyle, (XtArgVal) &c);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::dropRectangles(XRectangle * r)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNdropRectangles, (XtArgVal) r);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

XRectangle *
DropSiteClass::dropRectangles()
{
   XRectangle *r;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNdropRectangles, (XtArgVal) &r);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return r;
}

void 
DropSiteClass::dropSiteActivity(unsigned char c)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0], (_XtString) XmNdropSiteActivity, (XtArgVal) c);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

unsigned char 
DropSiteClass::dropSiteActivity()
{
   unsigned char c;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0], (_XtString) XmNdropSiteActivity, (XtArgVal) &c);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::dropSiteOperations(unsigned char c)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNdropSiteOperations, (XtArgVal) c);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

unsigned char 
DropSiteClass::dropSiteOperations()
{
   unsigned char c;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNdropSiteOperations, (XtArgVal) &c);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

unsigned char 
DropSiteClass::dropSiteType()
{
   unsigned char c;
   Arg arglist[1]; 
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNdropSiteType, (XtArgVal) &c);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::importTargets(Atom *a)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNimportTargets, (XtArgVal) a);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Atom *
DropSiteClass::importTargets()
{
   Atom *a;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNimportTargets, (XtArgVal) &a);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return a;
}

void 
DropSiteClass::numDropRectangles(Cardinal c)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNnumDropRectangles, (XtArgVal) c);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Cardinal 
DropSiteClass::numDropRectangles()
{
   Cardinal c;
   Arg arglist[1];
   Cardinal argcount = 1;

 
   XtSetArg(arglist[0],(_XtString) XmNnumDropRectangles, (XtArgVal) &c);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

void 
DropSiteClass::numImportTargets(Cardinal c)
{
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNnumImportTargets, (XtArgVal) c);
   XmDropSiteUpdate(widget(),arglist, argcount);
}

Cardinal 
DropSiteClass::numImportTargets()
{
   Cardinal c;
   Arg arglist[1];
   Cardinal argcount = 1;

   XtSetArg(arglist[0],(_XtString) XmNnumImportTargets, (XtArgVal) &c);
   XmDropSiteRetrieve(widget(),arglist, argcount);
   return c;
}

