/* $Id: Tab.C,v 1.2 1997/04/08 15:20:59 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Tab.h>
/* TabClass member functions */
void
TabClass::autoSpace(int size)
{
   /* auto space buttons */
   int border = width();
   if(border < size) {
      int offset = (size-border)%2;
      border = (size - border)/2;
      XtVaSetValues(widget(),XmNmarginLeft,border,
         XmNmarginRight, ((Dimension) border+offset), NULL);
   } 
}

/* callbacks */
void
TabClass::activateCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNactivateCallback,fp,udata);
}

void
TabClass::armCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNarmCallback,fp,udata);
}

void
TabClass::disarmCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdisarmCallback,fp,udata);
}

/* resources */
void
TabClass::armColor(Pixel p)
{
   XtVaSetValues(widget(),XmNarmColor, p, NULL);
}

Pixel
TabClass::armColor()
{
   Pixel p;
   XtVaGetValues(widget(),XmNarmColor, &p, NULL);
   return p;
}

void
TabClass::armPixmap(Pixmap p)
{
   XtVaSetValues(widget(),XmNarmPixmap, p, NULL);
}

Pixmap
TabClass::armPixmap()
{
   Pixmap p;
   XtVaGetValues(widget(),XmNarmPixmap, &p, NULL);
   return p;
}

void
TabClass::cornerSize(int i)
{
   XtVaSetValues(widget(),XmNcornerSize, i, NULL);
}

int
TabClass::cornerSize()
{
   int i;
   XtVaGetValues(widget(),XmNcornerSize, &i, NULL);
   return i;
}

void
TabClass::cornerStyle(int i)
{
   XtVaSetValues(widget(), XmNcornerStyle, i, NULL);
}

int
TabClass::cornerStyle()
{
   int i;
   XtVaGetValues(widget(), XmNcornerStyle, &i, NULL);
   return i;
}

void
TabClass::fillOnArm(Boolean b)
{
   XtVaSetValues(widget(),XmNfillOnArm,b, NULL);
}

Boolean
TabClass::fillOnArm()
{
   Boolean b;
   XtVaGetValues(widget(),XmNfillOnArm, &b, NULL);
   return b;
}

void
TabClass::showAsActive(Boolean b)
{
   XtVaSetValues(widget(),XmNshowAsActive, b, NULL);
}

Boolean
TabClass::showAsActive()
{
   Boolean b;
   XtVaGetValues(widget(),XmNshowAsActive, &b, NULL);
   return b;
}

Widget
TabClass::createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist,
                       Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateTab(w_parent, name, arglist, cnt);
}

/* constructors */

Tab::Tab(Widget w_parent, char *str, _XtString name)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
   labelString(str);

   alignment(XmALIGNMENT_CENTER);

   manage();
}

Tab::Tab(Widget w_parent, ArgList arglist, Cardinal cnt, 
                       _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   
   widget(wid);
   manage();
}

Tab::Tab(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());

   widget(wid);
   manage();
}

Tab::Tab(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   
   widget(wid);
   manage();
}
