/* $Id: ToggleB.C,v 1.2 1997/04/08 15:21:00 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ToggleB.h>
/* ToggleButtonClass Members */
/* callbacks */
void
ToggleButtonClass::armCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNarmCallback,funcp,data);
}

void
ToggleButtonClass::disarmCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNdisarmCallback,funcp,data);
}

void
ToggleButtonClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* convenience routines */
Boolean 
ToggleButtonClass::getState()
{
   return XmToggleButtonGetState(widget());
}

void 
ToggleButtonClass::setState(Boolean state, Boolean notify)
{
   XmToggleButtonSetState(widget(), state, notify);
}

/* resources */
void
ToggleButtonClass::fillOnSelect(Boolean b)
{
   XtVaSetValues(widget(), XmNfillOnSelect, b, NULL);
}

Boolean
ToggleButtonClass::fillOnSelect()
{
   Boolean b;
   XtVaGetValues(widget(), XmNfillOnSelect, &b, NULL);
   return b;
}

void
ToggleButtonClass::indicatorOn(Boolean b)
{
   XtVaSetValues(widget(), XmNindicatorOn, b, NULL);
}

Boolean
ToggleButtonClass::indicatorOn()
{
   Boolean b;
   XtVaGetValues(widget(), XmNindicatorOn, &b, NULL);
   return b;
}

void
ToggleButtonClass::indicatorSize(Dimension d)
{
   XtVaSetValues(widget(), XmNindicatorSize, d, NULL);
}

Dimension
ToggleButtonClass::indicatorSize()
{
   Dimension d;
   XtVaGetValues(widget(), XmNindicatorSize, &d, NULL);
   return d;
}

void
ToggleButtonClass::indicatorType(unsigned char c)
{
   XtVaSetValues(widget(), XmNindicatorType, c, NULL);
}

unsigned char
ToggleButtonClass::indicatorType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNindicatorType, &c, NULL);
   return c;
}

void
ToggleButtonClass::selectColor(Pixel p)
{
   XtVaSetValues(widget(), XmNselectColor, p, NULL);
}

Pixel
ToggleButtonClass::selectColor()
{
   Pixel p;
   XtVaGetValues(widget(), XmNselectColor, &p, NULL);
   return p;
}

void
ToggleButtonClass::selectInsensitivePixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNselectInsensitivePixmap, p, NULL);
}

Pixmap
ToggleButtonClass::selectInsensitivePixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNselectInsensitivePixmap, &p, NULL);
   return p;
}

void
ToggleButtonClass::set(Boolean b)
{
   XtVaSetValues(widget(), XmNset, b, NULL);
}

Boolean
ToggleButtonClass::set()
{
   Boolean b;
   XtVaGetValues(widget(), XmNset, &b, NULL);
   return b;
}

void
ToggleButtonClass::spacing(Dimension d)
{
   XtVaSetValues(widget(), XmNspacing, d, NULL);
}

Dimension
ToggleButtonClass::spacing()
{
   Dimension d;
   XtVaGetValues(widget(), XmNspacing, &d, NULL);
   return d;
}

void
ToggleButtonClass::visibleWhenOff(Boolean b)
{
   XtVaSetValues(widget(), XmNvisibleWhenOff, b, NULL);
}

Boolean 
ToggleButtonClass::visibleWhenOff()
{
   Boolean b;
   XtVaGetValues(widget(), XmNvisibleWhenOff, &b, NULL);
   return b;
}

/* constructors */
ToggleButton::ToggleButton(Widget w_parent, char *str, KeySym mn,
                           _XtString acc, char *accText, _XtString name) 
{
   Widget w = createWidget(name, w_parent, NULL, 0);

   widget(w);
   labelString(str);
   manage();

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(accText) acceleratorText(accText);
}

ToggleButton::ToggleButton(Widget w_parent, ArgList arglist, Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);

   widget(w);
   manage();
}

ToggleButton::ToggleButton(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());

   widget(w);
   manage();
}

ToggleButton::ToggleButton(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}
