/* $Id: VendorS.C,v 1.1.1.1 1997/03/19 13:32:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/VendorS.h>

/* VendorShellClass Members */

void
VendorShellClass::deleteWindowCallback(XtCallbackProc func, XtPointer data)
{
   Atom wm_delete_window = XInternAtom(display(),"WM_DELETE_WINDOW", False);

   XmAddWMProtocols(widget(),&wm_delete_window,1);
   XmAddWMProtocolCallback(
      widget(),
      wm_delete_window,
      func,
      (caddr_t) data);

}


void
VendorShellClass::saveYourselfCallback(XtCallbackProc func, XtPointer data)
{
   Atom wm_save_yourself = XInternAtom(display(),"WM_SAVE_YOURSELF", False);

   XmAddWMProtocols(widget(),&wm_save_yourself,1);
   XmAddWMProtocolCallback(
      widget(),
      wm_save_yourself,
      func,
      (caddr_t) data);
}

void
VendorShellClass::takeFocusCallback(XtCallbackProc func, XtPointer data)
{
   Atom wm_take_focus = XInternAtom(display(),"WM_TAKE_FOCUS", False);

   XmAddWMProtocols(widget(),&wm_take_focus,1);
   XmAddWMProtocolCallback(
      widget(),
      wm_take_focus,
      func,
      (caddr_t) data);
}

void
VendorShellClass::audibleWarning(unsigned char audible)
{
   XtVaSetValues(widget(), XmNaudibleWarning, audible, NULL);
}

unsigned char
VendorShellClass::audibleWarning()
{
   unsigned char aud;
   XtVaGetValues(widget(), XmNaudibleWarning, &aud, NULL);
   return aud;
}

XmFontList
VendorShellClass::defaultFontList()
{
   XmFontList font_list;
   XtVaGetValues(widget(), XmNdefaultFontList, &font_list, NULL);
   return font_list;
}

void 
VendorShellClass::deleteResponse(unsigned char response)
{
   XtVaSetValues(widget(), XmNdeleteResponse, response, NULL);
}

unsigned char
VendorShellClass::deleteResponse()
{
   unsigned char response;
   XtVaGetValues(widget(), XmNdeleteResponse, &response, NULL);
   return response;
}

void
VendorShellClass::inputMethod(_XtString imethod)
{
   XtVaSetValues(widget(), XmNinputMethod, imethod, NULL);
}

_XtString
VendorShellClass::inputMethod()
{
   _XtString imethod;
   XtVaGetValues(widget(), XmNinputMethod, &imethod, NULL);
   return imethod;
}

void
VendorShellClass::keyboardFocusPolicy(unsigned char policy)
{
   XtVaSetValues(widget(), XmNkeyboardFocusPolicy, policy, NULL);
}

unsigned char
VendorShellClass::keyboardFocusPolicy()
{
   unsigned char policy;
   XtVaGetValues(widget(), XmNkeyboardFocusPolicy, &policy, NULL);
   return policy;
}

void
VendorShellClass::mwmDecorations(int decor)
{
   XtVaSetValues(widget(), XmNmwmDecorations, decor, NULL);
}

int
VendorShellClass::mwmDecorations()
{
   int decor;
   XtVaGetValues(widget(), XmNmwmDecorations, &decor, NULL);
   return decor;
}

void
VendorShellClass::mwmFunctions(int func)
{
   XtVaSetValues(widget(), XmNmwmFunctions, func, NULL);
}

int
VendorShellClass::mwmFunctions()
{
   int func;
   XtVaGetValues(widget(), XmNmwmFunctions, &func, NULL);
   return func;
}

void
VendorShellClass::mwmInputMode(int imode)
{
   XtVaSetValues(widget(), XmNmwmInputMode, imode, NULL);
}

int
VendorShellClass::mwmInputMode()
{
   int imode;
   XtVaGetValues(widget(), XmNmwmInputMode, &imode, NULL);
   return imode;
}

void
VendorShellClass::mwmMenu(_XtString item)
{
   XtVaSetValues(widget(), XmNmwmMenu, item, NULL);
}

_XtString
VendorShellClass::mwmMenu()
{
   _XtString item;
   XtVaGetValues(widget(), XmNmwmMenu, &item, NULL);
   return item;
}

void
VendorShellClass::preeditType(_XtString style)
{
   XtVaSetValues(widget(), XmNpreeditType, style, NULL);
}

_XtString
VendorShellClass::preeditType()
{
   _XtString style;
   XtVaGetValues(widget(), XmNpreeditType, &style, NULL);
   return style;
}

void
VendorShellClass::shellUnitType(unsigned char unit)
{
   XtVaSetValues(widget(), XmNshellUnitType, unit, NULL);
}

unsigned char
VendorShellClass::shellUnitType()
{
   unsigned char unit;
   XtVaGetValues(widget(), XmNshellUnitType, &unit, NULL);
   return unit;
}

void
VendorShellClass::useAsyncGeometry(Boolean use)
{
   XtVaSetValues(widget(), XmNuseAsyncGeometry, use, NULL);
}

Boolean
VendorShellClass::useAsyncGeometry()
{
   Boolean use;
   XtVaGetValues(widget(), XmNuseAsyncGeometry, &use, NULL);
   return use;
}

