/*
 Copyright (C) 1999, Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/XarmCaption.h>
#include <Xarm/RowColumn.h>
#include <Xarm/ToggleB.h>
#include <Xarm/Form.h>
#include <Xarm/Frame.h>
#include <Xarm/Callback.h>
#include <Xarm/MessageB.h>

#ifdef XARM_HAS_XBAE

/* Declaration(s) */

/* Structures to hold all the widgets we need!!! */

struct ColorData {
    Caption       *caption;
    Frame         *frame;
    Form          *form;
    RowColumn     *rc;
    ToggleButton  *redB;
    ToggleButton  *blueB;
    ToggleButton  *yellowB;
};

struct SizeData {
    Caption       *caption;
    Frame         *frame;
    Form          *form;
    RowColumn     *rc;
    ToggleButton  *smallB;
    ToggleButton  *mediumB;
    ToggleButton  *largeB;
};


class Application: public AppContext
{
 private:

   Form *mainForm;
   ColorData colorData;
   SizeData  sizeData;

   void createColors(Widget parent, XarmArg &args);
   void createSizes(Widget parent, XarmArg &args);

   void exit(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);

 public:

   Application(char *app_class,int &argc_in_out, char **argv_in_out);
   ~Application();
};

int main(int argc, char **argv)
{
   // initialize application
   Application app("xcaption",argc,argv);

   // realize application
   app.realize();

   // start the main loop
   app.mainLoop();

   // NOTE:  Xarm 1.3.0 will return from the main loop
   //        when you call AppContext::quit() !!!!!!!!
   //        So beware!
   return EXIT_SUCCESS;
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{
   XarmArg         args;                      // Arg List for Widgets

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   ::addWMProtocolCallback(this, &Application::onExit, widget(), proto);

   title("Xbae Caption Demo");

   // install window(s) into the application window

   mainForm = new Form("MainForm", *this);

   args(XmNtopAttachment,    XmATTACH_FORM)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNtopOffset,        20)
       (XmNleftOffset,       20)
       (XmNbottomOffset,     20)
       (XmNlabelOffset,      -12)
       (XmNlabelPosition,    XbaePositionTop)
       (XmNlabelAlignment,   XbaeAlignmentCenter);

   createColors(*mainForm, args);

   args.reset();
   args(XmNtopAttachment,    XmATTACH_FORM)
       (XmNleftAttachment,   XmATTACH_WIDGET)
       (XmNrightAttachment,  XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNleftWidget,       colorData.caption->widget())
       (XmNtopOffset,        20)
       (XmNleftOffset,       20)
       (XmNrightOffset,      20)
       (XmNbottomOffset,     20)
       (XmNlabelOffset,      -12)
       (XmNlabelPosition,    XbaePositionTop)
       (XmNlabelAlignment,   XbaeAlignmentCenter);

   createSizes(*mainForm, args);

   mainForm->manage();

}

Application::~Application()
{

    cout << "You selected a ";

    if      (sizeData.smallB->set())   cout << "small ";
    else if (sizeData.mediumB->set())  cout << "medium ";
    else if (sizeData.largeB->set())   cout << "large ";
    else                               cout << "enormous(?) ";

    if      (colorData.redB->set())    cout << "red ";
    else if (colorData.blueB->set())   cout << "blue ";
    else if (colorData.yellowB->set()) cout << "yellow ";
    else                               cout << "transparent(?) ";

    cout << "item." << endl;

    delete colorData.yellowB;
    delete colorData.blueB;
    delete colorData.redB;
    delete colorData.rc;
    delete colorData.form;
    delete colorData.frame;
    delete colorData.caption;

    delete sizeData.smallB;
    delete sizeData.mediumB;
    delete sizeData.largeB;
    delete sizeData.rc;
    delete sizeData.form;
    delete sizeData.frame;
    delete sizeData.caption;

    delete mainForm;
}

// You'd think that the Xbae Caption would do this for you!
// To make the caption look nice, you have to put a frame in it,
// give it a negative label offset so that the caption text
// sits on the frame, and then put things inside it.

void Application::createColors(Widget parent, XarmArg &parent_args)
{

   XarmArg args;

   /* Local definitions to reduce the clutter */
   Caption       *caption;
   Frame         *frame;
   Form          *form;
   RowColumn     *rc;
   ToggleButton  *redB;
   ToggleButton  *blueB;
   ToggleButton  *yellowB;

   caption = new Caption(parent, parent_args, "Colors");

   frame = new Frame("ColorFrame", *caption);

   form  = new Form("ColorInnerForm", *frame);

   args.reset();
   args(XmNradioBehavior,    True)
       (XmNtopAttachment,    XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNrightAttachment,  XmATTACH_FORM)
       (XmNleftOffset,       10)
       (XmNrightOffset,      10)
       (XmNtopOffset,        10)
       (XmNbottomOffset,     10);

   rc = new RowColumn(*form, args, "ColorRC");

   args.reset();
   args(XmNhighlightThickness, 0);

   redB    = new ToggleButton(*rc, args, "Red");
   blueB   = new ToggleButton(*rc, args, "Blue");
   yellowB = new ToggleButton(*rc, args, "Yellow");

   rc->manage();
   form->manage();
   frame->manage();
   caption->manage();
   redB->set(True);

   /* Save everything */
   colorData.caption  = caption;
   colorData.frame    = frame;
   colorData.form     = form;
   colorData.rc       = rc;
   colorData.redB     = redB;
   colorData.blueB    = blueB;
   colorData.yellowB  = yellowB;
}

void Application::createSizes(Widget parent, XarmArg &parent_args)
{

   XarmArg args;

   /* Local definitions to reduce the clutter */
   Caption       *caption;
   Frame         *frame;
   Form          *form;
   RowColumn     *rc;
   ToggleButton  *smallB;
   ToggleButton  *mediumB;
   ToggleButton  *largeB;

   caption = new Caption(parent, parent_args, "Sizes");

   frame = new Frame("SizeFrame", *caption);

   form  = new Form("SizeInnerForm", *frame);

   args.reset();
   args(XmNradioBehavior,    True)
       (XmNtopAttachment,    XmATTACH_FORM)
       (XmNbottomAttachment, XmATTACH_FORM)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNrightAttachment,  XmATTACH_FORM)
       (XmNleftOffset,       10)
       (XmNrightOffset,      10)
       (XmNtopOffset,        10)
       (XmNbottomOffset,     10);

   rc = new RowColumn(*form, args, "SizeRC");

   args.reset();
   args(XmNhighlightThickness, 0);

   smallB   = new ToggleButton(*rc, args, "Small");
   mediumB  = new ToggleButton(*rc, args, "Medium");
   largeB   = new ToggleButton(*rc, args, "Large");

   rc->manage();
   form->manage();
   frame->manage();
   caption->manage();
   smallB->set(True);

   /* Save everything */
   sizeData.caption  = caption;
   sizeData.frame    = frame;
   sizeData.form     = form;
   sizeData.rc       = rc;
   sizeData.smallB   = smallB;
   sizeData.mediumB  = mediumB;
   sizeData.largeB   = largeB;
}

void
Application::exit(Widget, XtPointer, XtPointer )
{
   quit();
}

void
Application::onExit(Widget w, XtPointer, XtPointer )
{

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");

   ::addCallback(this, &Application::exit, diag->widget(), XmNokCallback);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}

#else

// Bummer, you don't have the Xbae widgets!

int main()
{
    cout << "Sorry, this version of Xarm doesn't have Caption support!" << endl;
}

#endif // XARM_HAS_XBAE
