/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/XarmMatrix.h>

#ifdef XARM_HAS_XBAE

static String myRows[6][5] = { "Orange", "12",  "Rough",   "Inches",  "Large",
                               "Blue",   "323", "Smooth",  "Feet",    "Medium",
                               "Yellow", "456", "Bristly", "Meters",  "Large",
                               "Green",  "1",   "Knobby",  "Miles",   "Small",
                               "Pink",   "33",  "Hairy",   "Quarts",  "Small",
                               "Black",  "7",   "Silky",   "Gallons", "Small" };


static String *myCells[6] = { &myRows[0][0],
                              &myRows[1][0],
			      &myRows[2][0],
			      &myRows[3][0],
			      &myRows[4][0],
			      &myRows[5][0] };

struct ColorInfo {
    char *name;
    Pixel value;
};

static ColorInfo myColors[] = { { "white",        0 },
				{ "antiquewhite", 0 },
				{ "blue",         0 },
				{ "black",        0 } };

static Pixel rowBackground[6][5];

static Pixel *cellBackgrounds[6] = { &rowBackground[0][0],
				     &rowBackground[1][0],
				     &rowBackground[2][0],
				     &rowBackground[3][0],
				     &rowBackground[4][0],
				     &rowBackground[5][0] };

static Pixel rowColors[6][5];

static Pixel *cellColors[6] = { &rowColors[0][0],
				&rowColors[1][0],
				&rowColors[2][0],
				&rowColors[3][0],
				&rowColors[4][0],
				&rowColors[5][0] };

static char *rowLabels[] = { "1", "2", "3", "4", "5", "6" };

static char *columnLabels[] = { "Color", "#", "Texture", "Measure", "Size" };

_XtString fallbacks[] = {

"*mw.columns:            5",
"*mw.rows:               6",
"*mw.columnWidths:       8, 3, 10, 10, 10",
"*mw.allowColumnResize:  True",
"*mw.columnLabelAlignments:alignment_beginning, alignment_center,"
"                        alignment_beginning, alignment_beginning,"
"                        alignment_beginning",
"*mw.columnAlignments:   alignment_beginning, alignment_end,"
"                        alignment_beginning, alignment_beginning,"
"                        alignment_beginning",
"*labelFont:             -*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*",
"*fontList:              -*-helvetica-medium-r-*-*-10-*-*-*-*-*-*-*",
"*cellHighlightThickness: 2",
"*cellShadowThickness: 2",
"*cellMarginWidth: 0",
"*cellMarginHeight: 3",
"*gridType:              grid_shadow_out",
"*rowLabelColor: Red",
"*columnLabelColor:      Blue",
"*mw.buttonLabels:               True",
"",
NULL
};

/* Declaration(s) */
class Application: public AppContext
{
 private:

   Matrix *myMatrix;

 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }
   return s;
}

int
main (int argc, char **argv)
{
   // initialize application
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out, fallbacks)
{

   title(app_class);

   // Create all the colors we need
   XrmValue fromVal, toVal;

   for (int x = 0; x < 4; x++) {
       fromVal.size = strlen(myColors[x].name) + 1;
       fromVal.addr = myColors[x].name;
       toVal.size = sizeof(Pixel);
       toVal.addr = (char *)&myColors[x].value;
       XtConvertAndStore(widget(), XtRString, &fromVal, XtRPixel, &toVal);
   }

   // Fill in the row backgrounds...
   rowBackground[0][0] = rowBackground[0][2] = rowBackground[0][3] = myColors[0].value;
   rowBackground[1][0] = rowBackground[1][2] = rowBackground[1][3] = myColors[0].value;
   rowBackground[2][0] = rowBackground[2][2] = rowBackground[2][3] = myColors[0].value;
   rowBackground[3][0] = rowBackground[3][2] = rowBackground[3][3] = myColors[0].value;
   rowBackground[4][0] = rowBackground[4][2] = rowBackground[4][3] = myColors[0].value;
   rowBackground[5][0] = rowBackground[5][2] = rowBackground[5][3] = myColors[0].value;

   rowBackground[0][1] = rowBackground[0][4] = myColors[1].value;
   rowBackground[1][1] = rowBackground[1][4] = myColors[1].value;
   rowBackground[2][1] = rowBackground[2][4] = myColors[1].value;
   rowBackground[3][1] = rowBackground[3][4] = myColors[1].value;
   rowBackground[4][1] = rowBackground[4][4] = myColors[1].value;
   rowBackground[5][1] = rowBackground[5][4] = myColors[1].value;

   // Fill in cell color table...
   rowColors[0][0] = rowColors[0][2] = rowColors[0][3] = myColors[2].value;
   rowColors[1][0] = rowColors[1][2] = rowColors[1][3] = myColors[2].value;
   rowColors[2][0] = rowColors[2][2] = rowColors[2][3] = myColors[2].value;
   rowColors[3][0] = rowColors[3][2] = rowColors[3][3] = myColors[2].value;
   rowColors[4][0] = rowColors[4][2] = rowColors[4][3] = myColors[2].value;
   rowColors[5][0] = rowColors[5][2] = rowColors[5][3] = myColors[2].value;

   rowColors[0][1] = rowColors[0][4] = myColors[3].value;
   rowColors[1][1] = rowColors[1][4] = myColors[3].value;
   rowColors[2][1] = rowColors[2][4] = myColors[3].value;
   rowColors[3][1] = rowColors[3][4] = myColors[3].value;
   rowColors[4][1] = rowColors[4][4] = myColors[3].value;
   rowColors[5][1] = rowColors[5][4] = myColors[3].value;

   // install window(s) into the application window
   myMatrix = new Matrix("mw", widget());

   myMatrix->cells(myCells);
   myMatrix->cellBackgrounds(cellBackgrounds);
   myMatrix->colors(cellColors);
   myMatrix->rowLabels(rowLabels);
   myMatrix->columnLabels(columnLabels);
}

#else

int main()
{
    cout << "Sorry, you don't have the Xbae Matrix widget support included." << endl;
    return 0;
}

#endif // XARM_HAS_XBAE
