/* $Id: CDESpinBox.h,v 1.6 1999/01/15 01:01:45 glgay Exp $ */
/*
 Copyright (C) 1997 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#include <Dt/SpinBox.h>
#include <Xarm/Manager.h>

class SpinBoxClass : public ManagerClass {
 protected:
   SpinBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return dtSpinBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "dtSpinBox"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   void modifyVerifyCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void valueChangedCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */
   void          arrowLayout(unsigned char);
   unsigned char arrowLayout() const;
   void          arrowSize(Dimension);
   Dimension     arrowSize() const;
   void          initialDelay(unsigned int);
   unsigned int  initialDelay() const;
   void          repeatDelay(unsigned int);
   unsigned int  repeatDelay() const;
   void          arrowSensitivity(unsigned char);
   unsigned char arrowSensitivity() const;
   void          decimalPoints(short);
   short         decimalPoints() const;
   void          incrementValue(int);
   int           incrementValue() const;
   void          maximumValue(int);
   int           maximumValue() const;
   void          minimumValue(int);
   int           minimumValue() const;
   void          numValues(int);
   int           numValues() const;
   void          position(int);
   int           position() const;
   unsigned char spinBoxChildType() const;
   void          values(const XmStringTable);
   XmStringTable values() const;

   /* Extra functionality */
   void values(const char **, const int c);
   void add(const char *, int = 0);
   void del(int);
   void setItem(const char *);
};

class SpinBox : public SpinBoxClass {

 public:
   SpinBox(Widget p,
            ArgList arglist = NULL,
            Cardinal cnt = 0,
            _XtString name = NULL);
   SpinBox(_XtString name, Widget p);
   SpinBox(Widget w_parent, XarmArg &args, _XtString name);
};
