/* $Id: FileSB.h,v 1.3 1999/01/15 09:47:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_FILESB_H_)
#define _XARM_FILESB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/SelectioB.h>

class FileSelectionBoxClass : public SelectionBoxClass {
 protected:
   FileSelectionBoxClass() {}
   virtual WidgetClass classPointer() { return xmFileSelectionBoxWidgetClass; } 
   virtual _XtString className() { return (_XtString) "XmFileSelectionBox"; }
 public:
   /* convenience routines */
   virtual Widget getChild(unsigned char);
   void doSearch(const char *str); 

   /* resources */
   void directory(const char *);
   char *directory() const;
   void directoryValid(Boolean);
   Boolean directoryValid() const;
   void dirListItems(const XmStringTable);
   XmStringTable dirListItems() const;
   void dirListItemCount(int);
   int dirListItemCount() const;
   void dirListLabelString(const char *);
   char *dirListLabelString() const;
   void dirMask(const char *);
   char *dirMask() const;
   void dirSearchProc(XmSearchProc);
   XmSearchProc dirSearchProc() const;
   void dirSpec(const char *);
   char *dirSpec() const;
   void fileListItems(const XmStringTable);
   XmStringTable fileListItems() const;
   void fileListItemCount(int);
   int fileListItemCount() const;
   void fileListLabelString(const char *);
   char *fileListLabelString() const;
   void fileSearchProc(XmSearchProc);
   XmSearchProc fileSearchProc() const;
   void fileTypeMask(unsigned char);
   unsigned char fileTypeMask() const;
   void filterLabelString(const char *);
   char *filterLabelString() const;
   void listUpdated(Boolean);
   Boolean listUpdated() const;
   void noMatchString(const char *);
   char *noMatchString() const;
   void pattern(const char *);
   char * pattern() const;
   void qualifySearchDataProc(XmQualifyProc);
   XmQualifyProc qualifySearchDataProc() const;
   
 
};

class FileSelectionBox : public FileSelectionBoxClass {
 public:
   FileSelectionBox(Widget w_parent, 
                    ArgList arglist = NULL, 
                    Cardinal cnt = 0,
                    _XtString name = NULL);
   FileSelectionBox(_XtString name, Widget w_parent);
   FileSelectionBox(Widget w_parent, XarmArg &args, _XtString name);
};

class FileSelectionDialog : public FileSelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent, 
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   FileSelectionDialog(Widget w_parent, 
                       ArgList arglist = NULL, 
                       Cardinal cnt = 0,
                       _XtString name = NULL);
   FileSelectionDialog(_XtString name, Widget w_parent);
   FileSelectionDialog(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
