/* $Id: Primitive.h,v 1.4 1998/07/24 18:52:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_PRIMITIVE_H_)
#define _XARM_PRIMITIVE_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Core.h>

class PrimitiveClass : public CoreClass {
 protected:
   PrimitiveClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void helpCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   void bottomShadowColor(Pixel);
   Pixel bottomShadowColor() const;
   void bottomShadowPixmap(Pixmap);
   Pixmap bottomShadowPixmap() const;
   void foreground(Pixel);
   Pixel foreground() const;
   void highlightColor(Pixel);
   Pixel highlightColor() const;
   void highlightOnEnter(Boolean);
   Boolean highlightOnEnter() const;
   void highlightPixmap(Pixmap);
   Pixmap highlightPixmap() const;
   void highlightThickness(Dimension);
   Dimension highlightThickness() const;
   void navigationType(const XmNavigationType);
   XmNavigationType navigationType() const;
   void shadowThickness(Dimension);
   Dimension shadowThickness() const;
   void topShadowColor(Pixel);
   Pixel topShadowColor() const;
   void topShadowPixmap(Pixmap);
   Pixmap topShadowPixmap() const;
   void traversalOn(Boolean on); 
   Boolean traversalOn() const; 
   void unitType(unsigned char c);
   unsigned char unitType() const;
   void userData(XtPointer udata);
   XtPointer userData() const; 

   // Additional functionality
   void bottomShadowColor(const char *);
   void foreground(const char *);
   void highlightColor(const char *);
   void topShadowColor(const char *);
};

#endif
