/* $Id: Registry.h,v 1.1.1.1 1997/03/19 13:32:20 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_REGISTRY_H_)
#define _XARM_REGISTRY_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ConRes.h>

class DropSiteClass : public ConstraintResources
{
 protected:
   DropSiteClass() {}
 public:
   /* callbacks */
   void dragProc(XtCallbackProc, XtPointer);
   void dropProc(XtCallbackProc, XtPointer);

   /* convenience routines */
   void configureStackingOrder(Widget sibling, Cardinal stack_mode);
   void endUpdate();
   Status queryStackingOrder(Widget *w_parent_ret, 
                             Widget **children_ret, 
                             Cardinal *num_children_ret) const;
   void Register(ArgList arglist = NULL, Cardinal cnt = 0);
   void retrieve(ArgList arglist, Cardinal cnt);
   void startUpdate();
   void update(ArgList arglist, Cardinal cnt);
   void unregister();
   
   /* resources */
   void animationMask(Pixmap);
   Pixmap animationMask() const;
   void animationPixmap(Pixmap);
   Pixmap animationPixmap() const;
   void animationPixmapDepth(int);
   int animationPixmapDepth() const;
   void animationStyle(unsigned char);
   unsigned char animationStyle() const;
   void dropRectangles(const XRectangle *);
   XRectangle *dropRectangles() const;
   void dropSiteActivity(unsigned char);
   unsigned char dropSiteActivity() const;
   void dropSiteOperations(unsigned char);
   unsigned char dropSiteOperations() const;
   unsigned char dropSiteType() const;
   void importTargets(const Atom *);
   Atom *importTargets() const;
   void numDropRectangles(Cardinal);
   Cardinal numDropRectangles() const;
   void numImportTargets(Cardinal);
   Cardinal numImportTargets() const;
};

#endif

