/* $Id: Shell.h,v 1.3 1997/04/07 15:33:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_SHELL_H_)
#define _XARM_SHELL_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Composite.h>

class ShellClass : public CompositeClass {
 protected:
   ShellClass() {}
   
   virtual WidgetClass classPointer() { return shellWidgetClass; }
   virtual _XtString className() { return (_XtString) "Shell"; }
 public:
   /* callbacks */
   void popdownCallback(XtCallbackProc fp, XtPointer data = NULL);
   void popupCallback(XtCallbackProc fp, XtPointer data = NULL);

   /* convenience routines */
   void activateProtocol(Atom property, Atom protocol);
   void activateWMProtocol(Atom protocol);

   /* resources */
   Boolean allowShellResize() const;
   void createPopupChildProc(XtCreatePopupChildProc);
   XtCreatePopupChildProc createPopupChildProc();
   void geometry(const _XtString);
   _XtString geometry() const;
   void overrideRedirect(Boolean);
   Boolean overrideRedirect() const;
   void saveUnder(Boolean);
   Boolean saveUnder() const;
   void visual(const Visual *);
   Visual *visual() const;
};


class WMShellClass : public ShellClass {
 protected:
   WMShellClass() {}

   virtual WidgetClass classPointer() { return wmShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "WMShell"; }
 public:
   /* resources */
   void baseHeight(int);
   int baseHeight() const;
   void baseWidth(int);
   int baseWidth() const;
   void heightInc(int);
   int heightInc() const;
   void iconMask(Pixmap);
   Pixmap iconMask() const;
   void iconPixmap(Pixmap);
   Pixmap iconPixmap() const;
   void iconWindow(Window);
   Window iconWindow() const;
   void iconX(int);
   int iconX() const;
   void iconY(int);
   int iconY() const;
   void initialState(int);
   int initialState() const;
   void input(Boolean);
   Boolean input() const;
   void maxAspectX(int);
   int maxAspectX() const;
   void maxAspectY(int);
   int maxAspectY() const;
   void maxHeight(int);
   int maxHeight() const;
   void maxWidth(int);
   int maxWidth() const;
   void minAspectX(int);
   int minAspectX() const;
   void minAspectY(int);
   int minAspectY() const;
   void minHeight(int);
   int minHeight() const;
   void minWidth(int);
   int minWidth() const;
   void title(const _XtString);
   _XtString title() const;
   void titleEncoding(Atom);
   Atom titleEncoding() const;
   void transient(Boolean);
   Boolean transient() const;
   void waitForWm(Boolean);
   Boolean waitForWm() const;
   void widthInc(int);
   int widthInc() const;
   void windowGroup(Window);
   Window windowGroup() const;
   void winGravity(int);
   int winGravity() const;
   void wmTimeout(int);
   int wmTimeout() const;
};

#include <Xarm/VendorS.h>

class TransientShellClass : public VendorShellClass {
 protected:
   TransientShellClass() {}

   virtual WidgetClass classPointer() { return transientShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "TransientShell"; }
 public:
   /* resources */
   void transientFor(Widget);
   Widget transientFor() const;
};

class TopLevelShellClass : public VendorShellClass {
 protected:
   TopLevelShellClass() {}

   virtual WidgetClass classPointer() { return topLevelShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "TopLevelShell"; }
 public:
   /* resources */
   void iconic(Boolean);
   Boolean iconic() const;
   void iconName(const _XtString);
   _XtString iconName() const;
   void iconNameEncoding(Atom);
   Atom iconNameEncoding() const;

   /* extra */
   void realize();
   void unrealize(); 
};

class TopLevelShell : public TopLevelShellClass {
 public:
   TopLevelShell(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   TopLevelShell(_XtString name, Widget w_parent);
   TopLevelShell(Widget w_parent, XarmArg &args, _XtString name);
};

class PopupShell : public TopLevelShellClass {
  protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PopupShell(Widget w_parent,
              ArgList arglist = NULL,
              Cardinal cnt = 0,
              _XtString name = NULL);
   PopupShell(_XtString name, Widget w_parent);
   PopupShell(Widget w_parent, XarmArg &args, _XtString name);
   void popup();
   void popdown();
};

class OverrideShellClass : public ShellClass {
 protected:
   OverrideShellClass() {}

   virtual WidgetClass classPointer() { return overrideShellWidgetClass; }
   virtual _XtString className() { return (_XtString) "OverrideShell"; }
};

#endif
