/* $Id: XmextXpm.h,v 1.1.1.1 1997/03/19 13:32:21 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/
/*
 * This is based on xpm 3.4.8 and 3.4.7
 *
 * This code comes from the Xpm library, which is distributed with the
 * following copyright:
 */
/*
 * Copyright (C) 1989-95 GROUPE BULL
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of GROUPE BULL shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from GROUPE BULL.
 */

#if !defined(_XMEXT_XPM_H_)
#define _XMEXT_XPM_H_

#include <X11/X.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>

#if defined(__cplusplus)
extern "C" {
#endif

/* Return ErrorStatus codes:
 * null     if full success
 * positive if partial success
 * negative if failure
 */

#define XmextXpmColorError    1
#define XmextXpmSuccess       0
#define XmextXpmOpenFailed   -1
#define XmextXpmFileInvalid  -2
#define XmextXpmNoMemory     -3
#define XmextXpmColorFailed  -4

/* the following should help people wanting to use their own functions */
#define XmextXpmFree(ptr) free(ptr)

typedef struct {
    char *name;			/* Symbolic color name */
    char *value;		/* Color value */
    Pixel pixel;		/* Color pixel */
}      XmextXpmColorSymbol;

typedef struct {
    char *name;			/* name of the extension */
    unsigned int nlines;	/* number of lines in this extension */
    char **lines;		/* pointer to the extension array of strings */
}      XmextXpmExtension;

typedef struct {
    char *string;		/* characters string */
    char *symbolic;		/* symbolic name */
    char *m_color;		/* monochrom default */
    char *g4_color;		/* 4 level grayscale default */
    char *g_color;		/* other level grayscale default */
    char *c_color;		/* color default */
}      XmextXpmColor;

typedef struct {
    unsigned int width;		/* image width */
    unsigned int height;	/* image height */
    unsigned int cpp;		/* number of characters per pixel */
    unsigned int ncolors;	/* number of colors */
    XmextXpmColor *colorTable;	/* list of related colors */
    unsigned int *data;		/* image data */
}      XmextXpmImage;

typedef struct {
    unsigned long valuemask;	/* Specifies which attributes are defined */
    char *hints_cmt;		/* Comment of the hints section */
    char *colors_cmt;		/* Comment of the colors section */
    char *pixels_cmt;		/* Comment of the pixels section */
    unsigned int x_hotspot;	/* Returns the x hotspot's coordinate */
    unsigned int y_hotspot;	/* Returns the y hotspot's coordinate */
    unsigned int nextensions;	/* number of extensions */
    XmextXpmExtension *extensions;	/* pointer to array of extensions */
}      XmextXpmInfo;

typedef struct {
    unsigned long valuemask;		/* Specifies which attributes are
					 * defined */

    Visual *visual;			/* Specifies the visual to use */
    Colormap colormap;			/* Specifies the colormap to use */
    unsigned int depth;			/* Specifies the depth */
    unsigned int width;			/* Returns the width of the created
					 * pixmap */
    unsigned int height;		/* Returns the height of the created
					 * pixmap */
    unsigned int x_hotspot;		/* Returns the x hotspot's
					 * coordinate */
    unsigned int y_hotspot;		/* Returns the y hotspot's
					 * coordinate */
    unsigned int cpp;			/* Specifies the number of char per
					 * pixel */
    Pixel *pixels;			/* List of used color pixels */
    unsigned int npixels;		/* Number of used pixels */
    XmextXpmColorSymbol *colorsymbols;	/* Array of color symbols to
					 * override */
    unsigned int numsymbols;		/* Number of symbols */
    char *rgb_fname;			/* RGB text file name */
    unsigned int nextensions;		/* number of extensions */
    XmextXpmExtension *extensions;		/* pointer to array of extensions */

    unsigned int ncolors;               /* Number of colors */
    XmextXpmColor *colorTable;               /* Color table pointer */
/* 3.2 backward compatibility code */
    char *hints_cmt;                    /* Comment of the hints section */
    char *colors_cmt;                   /* Comment of the colors section */
    char *pixels_cmt;                   /* Comment of the pixels section */
/* end 3.2 bc */
    unsigned int mask_pixel;            /* Transparent pixel's color table
                                         * index */

    /* Color Allocation Directives */
    Bool exactColors;			/* Only use exact colors for visual */
    unsigned int closeness;		/* Allowable RGB deviation */
    unsigned int red_closeness;		/* Allowable red deviation */
    unsigned int green_closeness;	/* Allowable green deviation */
    unsigned int blue_closeness;	/* Allowable blue deviation */
    int color_key;			/* Use colors from this color set */

    Pixel *alloc_pixels;		/* Returns the list of alloc'ed color
					   pixels */
    Bool nalloc_pixels;			/* Returns the number of alloc'ed
					   color pixels */

    Bool alloc_close_colors;    	/* Specify whether close colors should
					   be allocated using XAllocColor
					   or not */
    int bitmap_format;			/* Specify the format of 1bit depth
					   images: ZPixmap or XYBitmap */

}      XmextXpmAttributes;

/* XmextXpmAttributes value masks bits */
#define XmextXpmVisual	   (1L<<0)
#define XmextXpmColormap	   (1L<<1)
#define XmextXpmDepth	   (1L<<2)
#define XmextXpmSize		   (1L<<3)	/* width & height */
#define XmextXpmHotspot	   (1L<<4)	/* x_hotspot & y_hotspot */
#define XmextXpmCharsPerPixel   (1L<<5)
#define XmextXpmColorSymbols	   (1L<<6)
#define XmextXpmRgbFilename	   (1L<<7)
/* 3.2 backward compatibility code */
#define XmextXpmInfos	   (1L<<8)
#define XmextXpmReturnInfos	   XmextXpmInfos
/* end 3.2 bc */
#define XmextXpmReturnPixels	   (1L<<9)
#define XmextXpmExtensions      (1L<<10)
#define XmextXpmReturnExtensions XmextXpmExtensions

#define XmextXpmExactColors     (1L<<11)
#define XmextXpmCloseness	   (1L<<12)
#define XmextXpmRGBCloseness	   (1L<<13)
#define XmextXpmColorKey	   (1L<<14)

#define XmextXpmColorTable      (1L<<15)
#define XmextXpmReturnColorTable XmextXpmColorTable

#define XmextXpmReturnAllocPixels (1L<<16)
#define XmextXpmAllocCloseColors (1L<<17)
#define XmextXpmBitmapFormat    (1L<<18)

/* XmextXpmInfo value masks bits */
#define XmextXpmComments        XmextXpmInfos
#define XmextXpmReturnComments  XmextXpmComments

/* XmextXpmAttributes mask_pixel value when there is no mask */
#define XmextXpmUndefPixel 0x80000000

/*
 * color keys for visual type, they must fit along with the number key of
 * each related element in xpmColorKeys[] defined in XmextXpmI.h
 */
#define XPM_MONO	2
#define XPM_GREY4	3
#define XPM_GRAY4	3
#define XPM_GREY 	4
#define XPM_GRAY 	4
#define XPM_COLOR	5

/*
 * prototypes
 */
extern int	_XmextXpmCreateDataFromImage(Display *display,
					  char ***data_return,
					  XImage *image,
					  XImage *shapeimage,
					  XmextXpmAttributes *attributes);

extern int	_XmextXpmCreateImageFromData(Display *display,
					  char **data,
					  XImage **image_return,
					  XImage **shapemask_return,
					  XmextXpmAttributes *attributes);

extern void	_XmextXpmFreeAttributes(XmextXpmAttributes *attributes);

extern int	_XmextXpmReadFileToImage(Display *display,
				      char *filename,
				      XImage **image_return,
				      XImage **shapeimage_return,
				      XmextXpmAttributes *attributes);

extern int	_XmextXpmCreateDataFromPixmap(Display *display,
					   char ***data_return,
					   Pixmap pixmap,
					   Pixmap shapemask,
					   XmextXpmAttributes *attributes);

extern int      _XmextXpmCreatePixmapFromData(Display *display,
                                        Drawable d,
                                        char **data,
                                        Pixmap *pixmap_return,
                                        Pixmap *shapemask_return,
                                        XmextXpmAttributes *attributes);

extern int	_XmextXpmReadFileToPixmap(Display *display,
				       Drawable d,
				       char *filename,
				       Pixmap *pixmap_return,
				       Pixmap *shapemask_return,
				       XmextXpmAttributes *attributes);

#if defined(__cplusplus)
}
#endif

#endif /* _XMEXT_XPM_H_ */
