/* $Id: DragDrop.C,v 1.3 1999/01/15 09:38:42 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/DragDrop.h>

/* DragContextClass members */
void 
DragContextClass::dragDropFinishCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdragDropFinishCallback,fp,udata);
}

void 
DragContextClass::dragMotionCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdragMotionCallback,fp,udata);
}

void 
DragContextClass::dropFinishCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdropFinishCallback,fp,udata);
}

void 
DragContextClass::dropSiteEnterCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdropSiteEnterCallback,fp,udata);
}

void 
DragContextClass::dropSiteLeaveCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdropSiteLeaveCallback,fp,udata);
}

void 
DragContextClass::dropStartCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNdropStartCallback,fp,udata);
}

void 
DragContextClass::operationChangedCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNoperationChangedCallback,fp,udata);
}

void 
DragContextClass::topLevelEnterCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNtopLevelEnterCallback,fp,udata);
}

void 
DragContextClass::topLevelLeaveCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNtopLevelLeaveCallback,fp,udata);
}

   /* resources */
unsigned char 
DragContextClass::blendModel() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNblendModel, &c, NULL);
   return c;
}

void 
DragContextClass::clientData (XtPointer p)
{
   XtVaSetValues(widget(), XmNclientData, p, NULL);
}

XtPointer 
DragContextClass::clientData() const
{
   XtPointer p;
   XtVaGetValues(widget(), XmNclientData, &p, NULL);
   return p;
}

void 
DragContextClass::convertProc(XtConvertSelectionIncrProc fp)
{
   XtVaSetValues(widget(), XmNconvertProc, fp, NULL);
}

XtConvertSelectionIncrProc 
DragContextClass::convertProc() const
{
   XtConvertSelectionIncrProc fp; 
   XtVaGetValues(widget(), XmNconvertProc, &fp, NULL);
   return fp;
}

void 
DragContextClass::cursorBackground(Pixel p)
{
   XtVaSetValues(widget(), XmNcursorBackground, p, NULL);
}

void 
DragContextClass::cursorBackground(const char *p)
{
   XtVaSetValues(widget(), 
                 XtVaTypedArg, XmNcursorBackground, 
                 XmRString, p, (strlen(p) + 1),
                 NULL);
}

Pixel 
DragContextClass::cursorBackground() const
{
   Pixel p;
   XtVaGetValues(widget(), XmNcursorBackground, &p, NULL);
   return p;
}

void 
DragContextClass::cursorForeground(Pixel p)
{
   XtVaSetValues(widget(), XmNcursorForeground, p, NULL);
}

void 
DragContextClass::cursorForeground(const char *p)
{
   XtVaSetValues(widget(), 
                 XtVaTypedArg, XmNcursorForeground, 
                 XmRString, p, (strlen(p) + 1),
                 NULL);
}
Pixel 
DragContextClass::cursorForeground() const
{
   Pixel p;
   XtVaGetValues(widget(), XmNcursorForeground, &p, NULL);
   return p;
}

void 
DragContextClass::exportTargets(Atom *a)
{
   XtVaSetValues(widget(), XmNexportTargets, a, NULL);
}

Atom *
DragContextClass::exportTargets() const
{
   Atom *a;
   XtVaGetValues(widget(), XmNexportTargets, &a, NULL);
   return a;
}

void 
DragContextClass::incremental(Boolean b)
{
   XtVaSetValues(widget(), XmNincremental, b, NULL);
}

Boolean 
DragContextClass::incremental() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNincremental, &b, NULL);
   return b;
}

void 
DragContextClass::invalidCursorForeground(Pixel p)
{
   XtVaSetValues(widget(), XmNinvalidCursorForeground, p, NULL);
}

void 
DragContextClass::invalidCursorForeground(const char *p)
{
   XtVaSetValues(widget(), 
                 XtVaTypedArg, XmNinvalidCursorForeground, 
                 XmRString, p, (strlen(p) + 1),
                 NULL);
}
Pixel 
DragContextClass::invalidCursorForeground() const
{
   Pixel p;
   XtVaGetValues(widget(), XmNinvalidCursorForeground, &p, NULL);
   return p;
}

void
DragContextClass::noneCursorForeground(Pixel p)
{
   XtVaSetValues(widget(), XmNnoneCursorForeground, p, NULL);
}

void
DragContextClass::noneCursorForeground(const char *p)
{
   XtVaSetValues(widget(), 
                 XtVaTypedArg, XmNnoneCursorForeground, 
                 XmRString, p, (strlen(p) + 1),
                 NULL);
}
Pixel 
DragContextClass::noneCursorForeground() const
{
   Pixel p;
   XtVaGetValues(widget(), XmNnoneCursorForeground, &p, NULL);
   return p;
}

void 
DragContextClass::numExportTargets(Cardinal c)
{
   XtVaSetValues(widget(), XmNnumExportTargets, c, NULL);
}

Cardinal 
DragContextClass::numExportTargets() const
{
   Cardinal c;
   XtVaGetValues(widget(), XmNnumExportTargets, &c, NULL);
   return c;
}

void 
DragContextClass::operationCursorIcon(Widget w)
{
   XtVaSetValues(widget(), XmNoperationCursorIcon, w, NULL);
}

Widget 
DragContextClass::operationCursorIcon() const
{
   Widget w; 
   XtVaGetValues(widget(), XmNoperationCursorIcon, &w, NULL);
   return w;
}

void 
DragContextClass::sourceCursorIcon(Widget w)
{
   XtVaSetValues(widget(), XmNsourceCursorIcon, w, NULL);
}

Widget 
DragContextClass::sourceCursorIcon() const
{
   Widget w;
   XtVaGetValues(widget(), XmNsourceCursorIcon, &w, NULL);
   return w;
}

void 
DragContextClass::sourcePixmapIcon(Widget w)
{
   XtVaSetValues(widget(), XmNsourcePixmapIcon, w, NULL);
}

Widget 
DragContextClass::sourcePixmapIcon() const
{
   Widget w;
   XtVaGetValues(widget(), XmNsourcePixmapIcon, &w, NULL);
   return w;
}

void 
DragContextClass::stateCursorIcon(Widget w)
{
   XtVaSetValues(widget(), XmNstateCursorIcon, w, NULL);
}

Widget 
DragContextClass::stateCursorIcon() const
{
   Widget w;
   XtVaGetValues(widget(), XmNstateCursorIcon, &w, NULL);
   return w;
}

void 
DragContextClass::validCursorForeground(Pixel p)
{
   XtVaSetValues(widget(), XmNvalidCursorForeground, p, NULL);
}

void
DragContextClass::validCursorForeground(const char *p)
{
   XtVaSetValues(widget(), 
                 XtVaTypedArg, XmNvalidCursorForeground, 
                 XmRString, p, (strlen(p) + 1),
                 NULL);
}
Pixel 
DragContextClass::validCursorForeground() const
{
   Pixel p;
   XtVaGetValues(widget(), XmNvalidCursorForeground, &p, NULL);
   return p;
}

/* DragIconClass resources */
void
DragIconClass::attachment(unsigned char c)
{
   XtVaSetValues(widget(), XmNattachment, c, NULL);
}

unsigned char 
DragIconClass::attachment() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNattachment, &c, NULL);
   return c;
}

void 
DragIconClass::depth(int i)
{
   XtVaSetValues(widget(), XmNdepth, i, NULL);
}

int 
DragIconClass::depth() const
{
   int i;
   XtVaGetValues(widget(), XmNdepth, &i, NULL);
   return i;
}

void 
DragIconClass::height(Dimension d)
{
   XtVaSetValues(widget(), XmNheight, d, NULL);
}

Dimension 
DragIconClass::height() const
{
   Dimension d;
   XtVaSetValues(widget(), XmNheight, &d, NULL);
   return d;
}

void 
DragIconClass::hotX(Position p)
{
   XtVaSetValues(widget(), XmNhotX, p, NULL);
}

Position 
DragIconClass::hotX() const
{
   Position p;
   XtVaGetValues(widget(), XmNhotX, &p, NULL);
   return p;
}

void 
DragIconClass::hotY(Position p)
{
   XtVaSetValues(widget(), XmNhotY, p, NULL);
}

Position 
DragIconClass::hotY() const
{
   Position p;
   XtVaGetValues(widget(), XmNhotY, &p, NULL);
   return p;
}

void 
DragIconClass::mask(Pixmap p)
{
   XtVaSetValues(widget(), XmNmask, p, NULL);
}

Pixmap 
DragIconClass::mask() const
{
   Pixmap p;
   XtVaGetValues(widget(), XmNmask, &p, NULL);
   return p;
}

void 
DragIconClass::offsetX(Position p)
{
   XtVaSetValues(widget(), XmNoffsetX, p, NULL);
}

Position 
DragIconClass::offsetX() const
{
   Position p;
   XtVaGetValues(widget(), XmNoffsetX, &p, NULL);
   return p;
}

void 
DragIconClass::offsetY(Position p)
{
   XtVaSetValues(widget(), XmNoffsetY, p, NULL);
}

Position 
DragIconClass::offsetY() const
{
   Position p;
   XtVaGetValues(widget(), XmNoffsetY, &p, NULL);
   return p;
}

void 
DragIconClass::pixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNpixmap, p, NULL);
}

Pixmap 
DragIconClass::pixmap() const
{
   Pixmap p;
   XtVaGetValues(widget(), XmNpixmap, &p, NULL);
   return p;
}

void 
DragIconClass::width(Dimension d)
{
   XtVaSetValues(widget(), XmNwidth, d, NULL);
}

Dimension 
DragIconClass::width() const
{
   Dimension d;
   XtVaSetValues(widget(), XmNwidth, &d, NULL);
   return d;
}

/* DropTransferClass resources */
XmDropTransferEntryRec *
DropTransferClass::dropTransfers() const
{
   XmDropTransferEntryRec *rec;
   XtVaGetValues(widget(), XmNdropTransfers, &rec, NULL);
   return rec;
}

void 
DropTransferClass::incremental(Boolean b)
{
   XtVaSetValues(widget(), XmNincremental, b, NULL);
}

Boolean 
DropTransferClass::incremental() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNincremental, &b, NULL);
   return b;
}

void 
DropTransferClass::numDropTransfers(Cardinal c)
{
   XtVaSetValues(widget(), XmNnumDropTransfers, c, NULL);
}

Cardinal 
DropTransferClass::numDropTransfers() const
{
   Cardinal c;
   XtVaGetValues(widget(), XmNnumDropTransfers, &c, NULL);
   return c;
}

void 
DropTransferClass::transferProc(XtSelectionCallbackProc fp)
{
   XtVaSetValues(widget(), XmNtransferProc, fp, NULL);
}

XtSelectionCallbackProc
DropTransferClass::transferProc() const
{
   XtSelectionCallbackProc fp;
   XtVaGetValues(widget(), XmNtransferProc, &fp, NULL);
   return fp;
}

void 
DropTransferClass::transferStatus(unsigned char c)
{
   XtVaSetValues(widget(), XmNtransferStatus, c, NULL);
}

unsigned char 
DropTransferClass::transferStatus() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNtransferStatus, &c, NULL);
   return c;
}

