/* $Id: Gadget.C,v 1.4 1999/01/15 10:16:39 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/Gadget.h>

void 
GadgetClass::helpCallback(XtCallbackProc funcp, XtPointer data) 
{
   addCallback(XmNhelpCallback, funcp, data);
}

void 
GadgetClass::traversalOn(Boolean on) 
{
   XtVaSetValues(*this,XmNtraversalOn,on, NULL);
}

Boolean 
GadgetClass::traversalOn() const
{
   int on = FALSE;
   XtVaGetValues(*this,XmNtraversalOn,&on, NULL);
   return on;
}

void 
GadgetClass::userData(XtPointer udata) 
{
   XtVaSetValues(*this,XmNuserData,udata,NULL);
}

XtPointer 
GadgetClass::userData() const
{
      XtPointer udata;
      XtVaGetValues(*this,XmNuserData,&udata,NULL);
      return udata;
}

Pixel GadgetClass::bottomShadowColor() const
{
    Pixel px;

    XtVaGetValues(*this, XmNbottomShadowColor, &px, NULL);

    return px;
}

Pixel GadgetClass::highlightColor() const
{
    Pixel px;

    XtVaGetValues(*this, XmNhighlightColor, &px, NULL);

    return px;
}

Boolean GadgetClass::highlightOnEnter() const
{
    Boolean b;

    XtVaGetValues(*this, XmNhighlightOnEnter, &b, NULL);

    return b;
}

void GadgetClass::highlightOnEnter(Boolean b)
{
    XtVaSetValues(*this, XmNhighlightOnEnter, b, NULL);
}

void GadgetClass::highlightThickness(Dimension d)
{
    XtVaSetValues(*this, XmNhighlightThickness, d, NULL);
}

Dimension GadgetClass::highlightThickness() const
{
    Dimension d;

    XtVaGetValues(*this, XmNhighlightThickness, &d, NULL);

    return d;
}

void GadgetClass::navigationType(XmNavigationType nav)
{
    XtVaSetValues(*this, XmNnavigationType, nav, NULL);
}

XmNavigationType GadgetClass::navigationType() const
{
    XmNavigationType nav;

    XtVaGetValues(*this, XmNnavigationType, &nav, NULL);

    return nav;
}

void GadgetClass::shadowThickness(Dimension d)
{
    XtVaSetValues(*this, XmNshadowThickness, d, NULL);
}

Dimension GadgetClass::shadowThickness() const
{
    Dimension d;

    XtVaGetValues(*this, XmNshadowThickness, &d, NULL);

    return d;
}

Pixel GadgetClass::topShadowColor() const
{
    Pixel px;

    XtVaGetValues(*this, XmNtopShadowColor, &px, NULL);

    return px;
}

unsigned char GadgetClass::unitType() const
{
    unsigned char uc;

    XtVaGetValues(*this, XmNunitType, &uc, NULL);

    return uc;
}

void GadgetClass::unitType(unsigned char uc)
{
    XtVaSetValues(*this, XmNunitType, uc, NULL);
}
