/* $Id: List.C,v 1.5 1998/12/01 11:49:56 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/List.h>

/* ListClass Members */

/* callbacks */

void
ListClass::browseSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNbrowseSelectionCallback, fp, data);
}

void 
ListClass::defaultActionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNdefaultActionCallback, fp, data);
}

void 
ListClass::extendedSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNextendedSelectionCallback, fp, data);
}

void 
ListClass::multipleSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNmultipleSelectionCallback, fp, data);
}

void 
ListClass::singleSelectionCallback(XtCallbackProc fp, XtPointer data)
{
   addCallback(XmNsingleSelectionCallback, fp, data);
}

/* resources */

void
ListClass::automaticSelection(Boolean b)
{
   XtVaSetValues(widget(),XmNautomaticSelection, b, NULL);
}

Boolean
ListClass::automaticSelection() const
{
   Boolean b;
   XtVaGetValues(widget(),XmNautomaticSelection, &b, NULL);
   return b;
}

void 
ListClass::doubleClickInterval(int i)
{
   XtVaSetValues(widget(), XmNdoubleClickInterval, i, NULL);
}

int
ListClass::doubleClickInterval() const
{
   int i;
   XtVaGetValues(widget(), XmNdoubleClickInterval, &i, NULL);
   return i;
}

void
ListClass::fontList(const XmFontList fl)
{
   XtVaSetValues(widget(), XmNfontList, fl, NULL);
}

XmFontList
ListClass::fontList() const
{
   XmFontList fl;
   XtVaGetValues(widget(), XmNfontList, &fl, NULL);
   return fl;
}

void
ListClass::itemCount(int i)
{
   XtVaSetValues(widget(),XmNitemCount, i, NULL);
}

int
ListClass::itemCount() const
{
   int i;
   XtVaGetValues(widget(),XmNitemCount, &i, NULL);
   return i;
}

void
ListClass::items(const XmStringTable s)
{
   XtVaSetValues(widget(),XmNitems,s, NULL);
}

XmStringTable
ListClass::items() const
{
   XmStringTable s;
   XtVaGetValues(widget(),XmNitems, &s, NULL);
   return s;
}

void
ListClass::listMarginHeight(Dimension d)
{
   XtVaSetValues(widget(), XmNlistMarginHeight, d, NULL);
}

Dimension
ListClass::listMarginHeight() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNlistMarginHeight, &d, NULL);
   return d;
}

void
ListClass::listMarginWidth(Dimension d)
{
   XtVaSetValues(widget(), XmNlistMarginWidth, d, NULL);
}

Dimension
ListClass::listMarginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNlistMarginWidth, &d, NULL);
   return d;
}

unsigned char
ListClass::listSizePolicy() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNlistSizePolicy, &c, NULL);
   return c;
}

void
ListClass::listSpacing(Dimension d)
{
   XtVaSetValues(widget(), XmNlistSpacing, d, NULL);
}

Dimension
ListClass::listSpacing() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNlistSpacing, &d, NULL);
   return d;
}

void
ListClass::scrollBarDisplayPolicy(unsigned char c)
{
   XtVaSetValues(widget(), XmNscrollBarDisplayPolicy, c, NULL);
}

unsigned char
ListClass::scrollBarDisplayPolicy() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNscrollBarDisplayPolicy, &c, NULL);
   return c;
}

void
ListClass::selectedItemCount(int i)
{
   XtVaSetValues(widget(), XmNselectedItemCount, i, NULL);
}

int
ListClass::selectedItemCount() const
{
   int i;
   XtVaGetValues(widget(), XmNselectedItemCount, &i, NULL);
   return i;
}

void
ListClass::selectedItems(const XmStringTable s)
{
   XtVaSetValues(widget(), XmNselectedItems, s, NULL);
}

XmStringTable
ListClass::selectedItems() const
{
   XmStringTable s;
   XtVaGetValues(widget(), XmNselectedItems, &s, NULL);
   return s;
}

void
ListClass::selectionPolicy(unsigned char c)
{
   XtVaSetValues(widget(), XmNselectionPolicy, c, NULL);
}

unsigned char
ListClass::selectionPolicy() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNselectionPolicy, &c, NULL);
   return c;
}

void
ListClass::stringDirection(XmStringDirection s)
{
   XtVaSetValues(widget(), XmNstringDirection, s, NULL);
}

XmStringDirection
ListClass::stringDirection() const
{
   XmStringDirection s;
   XtVaGetValues(widget(), XmNstringDirection, &s, NULL);
   return s;
}

void
ListClass::topItemPosition(int i)
{
   XtVaSetValues(widget(), XmNtopItemPosition, i, NULL);
}

int
ListClass::topItemPosition() const
{
   int i;
   XtVaGetValues(widget(), XmNtopItemPosition, &i, NULL);
   return i;
}

void
ListClass::visibleItemCount(int i)
{
   XtVaSetValues(widget(), XmNvisibleItemCount, i, NULL);
}

int
ListClass::visibleItemCount() const
{
   int i;
   XtVaGetValues(widget(), XmNvisibleItemCount, &i, NULL);
   return i;
}


/* extras */
void 
ListClass::add(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListAddItem(widget(),xmstr,0);
   XmStringFree(xmstr);
}

void
ListClass::add(const char **l, int c)
{
   int i;
   XmString *xmstr = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListAddItems(widget(), xmstr, c, 0);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

void
ListClass::deselect(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   XmListDeselectItem(widget(), xmstr);
   XmStringFree(xmstr);
}
void
ListClass::deselect(int p)
{
   XmListDeselectPos(widget(), p);
}

void ListClass::deselectAll()
{
   XmListDeselectAllItems(widget());
}

void
ListClass::clear()
{
   XmListDeleteAllItems(widget());
}

int
ListClass::count() const
{
   int cnt;
   XtVaGetValues(widget(),XmNitemCount, &cnt, 0);
   return cnt;
}

void
ListClass::del(int p)
{
   XmListDeletePos(widget(),p);
}

void
ListClass::del(int n, int p)
{
   XmListDeleteItemsPos(widget(),n,p);
}

void
ListClass::del(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListDeleteItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::del(const char **slist, int n)
{
   int i;
   XmString *xmstr = new XmString [n];
   for(i=0; i<n; i++)
   {
      xmstr[i] = cvtStringToXmString(slist[i]);
   }
   XmListDeleteItems(widget(), xmstr, n);
   for(i = 0; i<n; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

int
ListClass::exists(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   int ret = (int) XmListItemExists(widget(),xmstr);
   XmStringFree(xmstr);
   return ret;
}

void
ListClass::horizontal(int p)
{
   XmListSetHorizPos(widget(),p);
}


void
ListClass::insert(const char *str, int p)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListAddItem(widget(),xmstr,p);
   XmStringFree(xmstr);
}

void
ListClass::insert(const char **l, int c, int p)
{
   int i;
   XmString *xmstr = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListAddItems(widget(), xmstr, c, p);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

int
ListClass::item(const char *str)
{
   XmString xmstr = cvtStringToXmString((char *) str);
   int ret = XmListItemPos(widget(),xmstr);
   XmStringFree(xmstr);
   return ret;
}
int
ListClass::match(const char *str, int * &p, int &c)
{
   int res = False;
   XmString xmstr = cvtStringToXmString(str);
   res = XmListGetMatchPos(widget(), xmstr, &p, &c);
   XmStringFree(xmstr);
   return res;
}

void
ListClass::replace(const char **l, int c, int p)
{
   int i;
   XmString *xmstr = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmstr[i] = cvtStringToXmString(l[i]);
   }
   XmListReplaceItemsPos(widget(), xmstr, c, p);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmstr[i]);
   } 
   delete [] xmstr;
}

void
ListClass::replace(const char **o, int c, const char **n)
{
   int i;
   XmString *xmold = new XmString [c];
   XmString *xmnew = new XmString [c];
   for(i=0; i<c; i++)
   {
      xmold[i] = cvtStringToXmString(o[i]);
      xmnew[i] = cvtStringToXmString(n[i]);
   }
   XmListReplaceItems(widget(), xmold, c, xmnew);
   for(i = 0; i<c; i++)
   {
      XmStringFree(xmold[i]);
      XmStringFree(xmnew[i]);
   } 
   delete [] xmold;
   delete [] xmnew;
}

Boolean
ListClass::selected(int * &slist, int &snum)
{
   return XmListGetSelectedPos(widget(), &slist, &snum);
}

void
ListClass::select(const char *str, int notify)
{
   XmString xmstr = cvtStringToXmString((char *)str);
   XmListSelectItem(widget(), xmstr, notify);
   XmStringFree(xmstr);
}
void
ListClass::select(int p, int notify)
{
   XmListSelectPos(widget(),p,notify);
}

void
ListClass::set(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListSetItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::set(int p)
{
   XmListSetPos(widget(),p);
} 

void
ListClass::setBottom(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XmListSetBottomItem(widget(), xmstr);
   XmStringFree(xmstr);
}

void
ListClass::setBottom(int p)
{
   XmListSetBottomPos(widget(), p);
}

/* constructors */
List::List(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

List::List(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

List::List(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}

Widget ScrolledList::createWidget(_XtString name,
                                Widget w_parent,
                                ArgList arglist,
                                Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateScrolledList(w_parent, name, arglist, cnt);
}

ScrolledList::ScrolledList(Widget w_parent,
                           ArgList arglist,
                           Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
   manage();
}

ScrolledList::ScrolledList(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

ScrolledList::ScrolledList(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   manage();
}
