/* $Id: ScrollBar.C,v 1.4 1998/07/24 18:53:32 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/ScrollBar.h>

void
ScrollBarClass::increment(int v)
{
   XtVaSetValues(widget(),XmNincrement,v, NULL);
}

int 
ScrollBarClass::increment() const
{
   int v;
   XtVaGetValues(widget(),XmNincrement,&v, NULL);
   return v;
}

void 
ScrollBarClass::initialDelay(int v)
{
   XtVaSetValues(widget(),XmNinitialDelay,v, NULL);
}

int 
ScrollBarClass::initialDelay() const
{
   int v;
   XtVaGetValues(widget(),XmNinitialDelay,&v, NULL);
   return v;
}

void 
ScrollBarClass::maximum(int v)
{
   XtVaSetValues(widget(),XmNmaximum,v, NULL);
}

int 
ScrollBarClass::maximum() const
{
   int v;
   XtVaGetValues(widget(),XmNmaximum,&v, NULL);
   return v;
}

void 
ScrollBarClass::minimum(int v)
{
   XtVaSetValues(widget(),XmNminimum,v, NULL);
}

int 
ScrollBarClass::minimum() const
{
   int v;
   XtVaGetValues(widget(),XmNminimum,&v, NULL);
   return v;
}

void ScrollBarClass::orientation(unsigned char v)
{
    XtVaSetValues(widget(),XmNorientation,v, NULL);
}

unsigned char ScrollBarClass::orientation() const
{
    unsigned char v;
    XtVaGetValues(widget(),XmNorientation,&v, NULL);
    return v;
}
   
void 
ScrollBarClass::processingDirection(unsigned char v)   
{
   XtVaSetValues(widget(),XmNprocessingDirection,v, NULL);
}

unsigned char 
ScrollBarClass::processingDirection() const
{
   unsigned char v;
   XtVaGetValues(widget(),XmNprocessingDirection,&v, NULL);
   return v;
}

void 
ScrollBarClass::repeatDelay(int v)
{
   XtVaSetValues(widget(),XmNrepeatDelay,v, NULL);
}

int 
ScrollBarClass::repeatDelay() const
{
   int v;
   XtVaGetValues(widget(),XmNrepeatDelay,&v, NULL);
   return v;
}

void 
ScrollBarClass::showArrows(Boolean v)
{
   XtVaSetValues(widget(),XmNshowArrows,v, NULL);
}

Boolean 
ScrollBarClass::showArrows() const
{
   Boolean v;
   XtVaGetValues(widget(),XmNshowArrows,&v, NULL);
   return v;
}

void 
ScrollBarClass::sliderSize(int v)
{
   XtVaSetValues(widget(),XmNsliderSize,v, NULL);
}

int
ScrollBarClass::sliderSize() const
{
   int v;
   XtVaGetValues(widget(),XmNsliderSize,&v, NULL);
   return v;
}

void 
ScrollBarClass::troughColor(Pixel v)
{
   XtVaSetValues(widget(),XmNtroughColor,v, NULL);
}

void 
ScrollBarClass::troughColor(const char *v)
{
   XtVaSetValues(widget(),
                 XtVaTypedArg, XmNtroughColor,
                 XmRString, v, (strlen(v) + 1),
                 NULL);
}

Pixel 
ScrollBarClass::troughColor() const
{
   Pixel v;
   XtVaGetValues(widget(),XmNtroughColor,&v, NULL);
   return v;
}

void 
ScrollBarClass::value(int v)
{
   XtVaSetValues(widget(),XmNvalue,v, NULL);
}

int 
ScrollBarClass::value() const
{
   int v;
   XtVaGetValues(widget(),XmNvalue,&v, NULL);
   return v;
}

void 
ScrollBarClass::decrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNdecrementCallback,funcp,data);
}

void 
ScrollBarClass::dragCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNdragCallback,funcp,data);
}

void 
ScrollBarClass::incrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNincrementCallback,funcp,data);
}

void 
ScrollBarClass::pageDecrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNpageDecrementCallback,funcp,data);
}

void 
ScrollBarClass::pageIncrementCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNpageIncrementCallback,funcp,data);
}

void 
ScrollBarClass::toBottomCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNtoBottomCallback,funcp,data);
}

void 
ScrollBarClass::toTopCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNtoTopCallback,funcp,data);
}

void 
ScrollBarClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)  
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}


/* constructors */

ScrollBar::ScrollBar(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

ScrollBar::ScrollBar(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

ScrollBar::ScrollBar(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}
