/* $Id: ScrolledW.C,v 1.4 1998/07/24 18:53:33 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/ScrolledW.h>
/* ScrolledWindowClass members */

/* callbacks */
void
ScrolledWindowClass::traverseObscuredCallback(XtCallbackProc fp, XtPointer udata)
{
   addCallback(XmNtraverseObscuredCallback,fp,udata);
}

/* resources */
Widget
ScrolledWindowClass::horizontalScrollBar() const
{
   Widget w;
   XtVaGetValues(widget(),XmNhorizontalScrollBar, &w, NULL);
   return w;
}

void
ScrolledWindowClass::horizontalScrollBar(Widget w)
{
   XtVaSetValues(widget(),XmNhorizontalScrollBar, w, NULL);
}

void
ScrolledWindowClass::scrollBarDisplayPolicy(unsigned char c)
{
   XtVaSetValues(widget(),XmNscrollBarDisplayPolicy, c, NULL);
}

unsigned char
ScrolledWindowClass::scrollBarDisplayPolicy() const
{
   unsigned char c;
   XtVaGetValues(widget(),XmNscrollBarDisplayPolicy, &c, NULL);
   return c;
}

void
ScrolledWindowClass::scrollBarPlacement(unsigned char c)
{
   XtVaSetValues(widget(),XmNscrollBarPlacement, c, NULL);
}

unsigned char
ScrolledWindowClass::scrollBarPlacement() const
{
   unsigned char c;
   XtVaGetValues(widget(),XmNscrollBarPlacement, &c, NULL);
   return c;
}

Dimension
ScrolledWindowClass::scrolledWindowMarginHeight() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNscrolledWindowMarginHeight, &d, NULL);
   return d;
}

void
ScrolledWindowClass::scrolledWindowMarginHeight(Dimension d)
{
   XtVaSetValues(widget(),XmNscrolledWindowMarginHeight, d, NULL);
}

Dimension
ScrolledWindowClass::scrolledWindowMarginWidth() const
{
   Dimension d;
   XtVaGetValues(widget(),XmNscrolledWindowMarginWidth, &d, NULL);
   return d;
}

void
ScrolledWindowClass::scrolledWindowMarginWidth(Dimension d)
{
   XtVaSetValues(widget(),XmNscrolledWindowMarginWidth, d, NULL);
}

unsigned char
ScrolledWindowClass::scrollingPolicy() const
{
   unsigned char policy;
   XtVaGetValues(widget(),XmNscrollingPolicy, &policy, NULL);
   return policy;
}

void
ScrolledWindowClass::spacing(int space)
{
   XtVaSetValues(widget(),XmNspacing, space, NULL);
}

int
ScrolledWindowClass::spacing() const
{
   int space;
   XtVaGetValues(widget(),XmNspacing, &space, NULL);
   return space;
}

Widget
ScrolledWindowClass::verticalScrollBar() const
{
   Widget w;
   XtVaGetValues(widget(),XmNverticalScrollBar, &w, NULL);
   return w;
}

void
ScrolledWindowClass::verticalScrollBar(Widget w)
{
   XtVaSetValues(widget(),XmNverticalScrollBar, w, NULL);
}

unsigned char
ScrolledWindowClass::visualPolicy() const
{
   unsigned char c;
   XtVaGetValues(widget(),XmNvisualPolicy, &c, NULL);
   return c;
}

void
ScrolledWindowClass::workWindow(Widget w)
{
   XtVaSetValues(widget(),XmNworkWindow, w, NULL);
}

Widget
ScrolledWindowClass::workWindow() const
{
   Widget w;
   XtVaGetValues(widget(),XmNworkWindow, &w, NULL);
   return w;
}

void ScrolledWindowClass::setArea(Widget hscroll, Widget vscroll, Widget work)
{
    XmScrolledWindowSetAreas(widget(), hscroll, vscroll, work);
}

/* constructor */
ScrolledWindow::ScrolledWindow(Widget w_parent,
                               ArgList arglist,
                               Cardinal cnt,
                               _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

ScrolledWindow::ScrolledWindow(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

ScrolledWindow::ScrolledWindow(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

