/* $Id: SelectioB.C,v 1.3 1998/07/24 18:53:33 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/SelectioB.h>
/* SelectionBoxClass Members */
/* callbacks */
void
SelectionBoxClass::applyCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNapplyCallback,funcp,data);
}
void
SelectionBoxClass::cancelCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNcancelCallback,funcp,data);
}
void
SelectionBoxClass::noMatchCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNnoMatchCallback,funcp,data);
}
void
SelectionBoxClass::okCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNokCallback,funcp,data);
}

/* convenience routines */
Widget 
SelectionBoxClass::getChild(unsigned char c)
{
   return XmSelectionBoxGetChild(widget(),c);
}

/* resources */

void 
SelectionBoxClass::applyLabelString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNapplyLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::applyLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNapplyLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void 
SelectionBoxClass::cancelLabelString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNcancelLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}


char *
SelectionBoxClass::cancelLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNcancelLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void 
SelectionBoxClass::childPlacement(unsigned char c)
{
   XtVaSetValues(widget(), XmNchildPlacement, c, NULL);
}


unsigned char 
SelectionBoxClass::childPlacement() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNchildPlacement, &c, NULL);
   return c;
}

void 
SelectionBoxClass::dialogType(unsigned char c)
{
   XtVaSetValues(widget(), XmNdialogType, c, NULL);
}


unsigned char 
SelectionBoxClass::dialogType() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNdialogType, &c, NULL);
   return c;
}

void 
SelectionBoxClass::helpLabelString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNhelpLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::helpLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNhelpLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

void 
SelectionBoxClass::listItemCount(int i)
{
   XtVaSetValues(widget(), XmNlistItemCount, i, NULL);
}


int 
SelectionBoxClass::listItemCount() const
{
   int i;
   XtVaGetValues(widget(), XmNlistItemCount, &i, NULL);
   return i;
}


void 
SelectionBoxClass::listItems(const XmStringTable st)
{
   XtVaSetValues(widget(), XmNlistItems, st, NULL);
}

XmStringTable 
SelectionBoxClass::listItems() const
{
   XmStringTable st;
   XtVaGetValues(widget(), XmNlistItems, &st, NULL);
   return st;
}

void 
SelectionBoxClass::listLabelString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNlistLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}
   
char *
SelectionBoxClass::listLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNlistLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}
   
void 
SelectionBoxClass::listVisibleItemCount(int i)
{
   XtVaSetValues(widget(), XmNlistVisibleItemCount, i, NULL);
}
   
int 
SelectionBoxClass::listVisibleItemCount() const
{
   int i;
   XtVaGetValues(widget(), XmNlistVisibleItemCount, &i, NULL);
   return i;
}

void 
SelectionBoxClass::minimizeButtons(Boolean b)
{
   XtVaSetValues(widget(), XmNminimizeButtons, b, NULL);
}
   
Boolean 
SelectionBoxClass::minimizeButtons() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNminimizeButtons, &b, NULL);
   return b;
}
   
void 
SelectionBoxClass::mustMatch(Boolean b)
{
   XtVaSetValues(widget(), XmNmustMatch, b, NULL);
}
   
Boolean 
SelectionBoxClass::mustMatch() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNmustMatch, &b, NULL);
   return b;
}
   
void 
SelectionBoxClass::okLabelString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNokLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}
   
char *
SelectionBoxClass::okLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNokLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}
   
void
SelectionBoxClass::selectionLabelString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNselectionLabelString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::selectionLabelString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNselectionLabelString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}
   
void 
SelectionBoxClass::textColumns(short s)
{
   XtVaSetValues(widget(), XmNtextColumns, s, NULL);
}
   
short 
SelectionBoxClass::textColumns() const
{
   short s;
   XtVaGetValues(widget(), XmNtextColumns, &s, NULL);
   return s;
}

void
SelectionBoxClass::textString(const char *str)
{
   XmString xmstr = cvtStringToXmString(str);
   XtVaSetValues(widget(), XmNtextString, xmstr, NULL);
   XmStringFree(xmstr);
}

char *
SelectionBoxClass::textString() const
{
   XmString xmstr;
   XtVaGetValues(widget(), XmNtextString, &xmstr, NULL);
   return cvtXmStringToString(xmstr);
}

/* constructors */
Widget
SelectionBox::createWidget(_XtString name,
                              Widget w_parent,
                              ArgList arglist,
                              Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateSelectionBox(w_parent, name, arglist, cnt);
}


SelectionBox::SelectionBox(Widget w_parent,
                           ArgList arglist,
                           Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt); 
   widget(w);
}

SelectionBox::SelectionBox(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

SelectionBox::SelectionBox(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent); 
   widget(w);
}

Widget
SelectionDialog::createWidget(_XtString name,
                              Widget w_parent,
                              ArgList arglist,
                              Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreateSelectionDialog(w_parent, name, arglist, cnt);
}

SelectionDialog::SelectionDialog(Widget w_parent,
                                 ArgList arglist,
                                 Cardinal cnt,
                                 _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt);
   widget(w);
}

SelectionDialog::SelectionDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

SelectionDialog::SelectionDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
}

Widget
PromptDialog::createWidget(_XtString name,
                              Widget w_parent,
                              ArgList arglist,
                              Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreatePromptDialog(w_parent, name, arglist, cnt);
}

PromptDialog::PromptDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   selectionLabelString(mesg);
}

PromptDialog::PromptDialog(Widget w_parent,
                           ArgList arglist,
                           Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt); 
   widget(w);
}

PromptDialog::PromptDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

PromptDialog::PromptDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent); 
   widget(w);
}

