/*
 Copyright (C) 1997, Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/XarmArg.h>

void XarmArg::reset()
{
    argVec.erase(argVec.begin(), argVec.end());
    if (theArgs != NULL) {
        delete [] theArgs;
        theArgs = NULL;
    }
    typedArgVec.erase(typedArgVec.begin(), typedArgVec.end());
}

ArgList XarmArg::getArgs()
{
    if (argVec.size() == 0) return NULL;

    if (theArgs != NULL) delete [] theArgs;

    theArgs = new Arg[argVec.size()];

    if (theArgs == NULL) return NULL;

    int last = argVec.size();
    Arg *oneArg = theArgs;

    for (int x = 0; x < last; x++) {
        oneArg->name  = argVec[x].name;
        oneArg->value = argVec[x].value;
        oneArg++;
    }

    return theArgs;
}

XarmArg &XarmArg::operator()(String name, XtArgVal value)
{
    Arg anArg;

    anArg.name  = name;
    anArg.value = value;
    argVec.push_back(anArg);
    return (*this);
}

XarmArg &XarmArg::operator()(String name, String from_type, XtPointer value, unsigned val_size)
{
    typedArg aTypedArg;

    aTypedArg.resource_name = name;
    aTypedArg.type_name     = from_type;
    aTypedArg.value         = value;
    aTypedArg.val_size      = val_size;
    typedArgVec.push_back(aTypedArg);
    return (*this);
}

void XarmArg::setTypedArgs(Widget w)
{
    for (vector<typedArg>::iterator tai = typedArgVec.begin();
         tai != typedArgVec.end(); ++tai) {
        XtVaSetValues(w, XtVaTypedArg,
                      tai->resource_name,
                      tai->type_name,
                      tai->value,
                      tai->val_size,
                      NULL);
    }
}
