/* $Id: Callback.h,v 1.4 1998/04/22 13:14:37 glgay Exp $ */
/*
 Copyright (C) 1996 Gerald L. Gay
 Copyright (C) 1996 Peter Williams

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(_XARM_CALLBACK_H_)
#define _XARM_CALLBACK_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/CallbackP.h>

template<class T>
void addCallback(T *obj, 
                 void (T::*func) (Widget, XtPointer, XtPointer),
                 Widget w, 
                 _XtString type, 
                 XtPointer closure=NULL)
   {
      CallbackInfo<T> *ci = new CallbackInfo<T>;

      if (ci == NULL) return;

      ci->_target   = obj;
      ci->_widget   = w;
      ci->_type     = type;
      ci->_callback = func;
      ci->_closure  = closure;

      registerCallback(ci);
   }

template <class T>
void addProtocolCallback(T *obj,
			 void (T::*func) (Widget, XtPointer, XtPointer),
			 Widget w,
			 Atom property,
			 Atom proto_atom,
			 XtPointer closure=NULL)
{
    ProtocolInfo<T> *pi = new ProtocolInfo<T>;

    if (pi == NULL) return;

    pi->_target     = obj;
    pi->_widget     = w;
    pi->_callback   = func;
    pi->_property   = property;
    pi->_protocol   = proto_atom;
    pi->_closure    = closure;

    registerProtoCallback(pi);

}

template <class T>
void addWMProtocolCallback(T *obj,
			 void (T::*func) (Widget, XtPointer, XtPointer),
			 Widget w,
			 Atom protocol,
			 XtPointer closure=NULL)
{
    ProtocolInfo<T> *pi = new ProtocolInfo<T>;

    if (pi == NULL) return;

    pi->_target     = obj;
    pi->_widget     = w;
    pi->_callback   = func;
    pi->_property   = XM_WM_PROTOCOL_ATOM(w);
    pi->_protocol   = protocol;
    pi->_closure    = closure;

    registerProtoCallback(pi);
}

template<class T>
void removeCallback(T *obj, 
                       void (T::*func) (Widget, XtPointer, XtPointer),
                       Widget w, 
                       _XtString type, 
                       XtPointer closure=NULL)
   {
      CallbackInfo<T> ci;

      ci._target=obj;
      ci._widget=w;
      ci._type=type;
      ci._callback=func;
      ci._closure=closure;

      unregisterCallback(&ci);
   }

template<class T>
void removeProtocolCallback(T *obj, 
                            void (T::*func) (Widget, XtPointer, XtPointer),
                            Widget w, 
			    Atom property,
			    Atom proto_atom,
			    XtPointer closure=NULL)
   {
      ProtocolInfo<T> pi;

      pi._target     = obj;
      pi._widget     = w;
      pi._property   = property;
      pi._protocol   = proto_atom;
      pi._callback   = func;
      pi._closure    = closure;

      unregisterProtoCallback(&pi);
   }

template<class T>
void removeWMProtocolCallback(T *obj, 
			      void (T::*func) (Widget, XtPointer, XtPointer),
			      Widget w, 
			      Atom protocol,
			      XtPointer closure=NULL)
   {
      ProtocolInfo<T> pi;

      pi._target     = obj;
      pi._widget     = w;
      pi._property   = XM_WM_PROTOCOL_ATOM(w);
      pi._protocol   = protocol;
      pi._callback   = func;
      pi._closure    = closure;

      unregisterProtoCallback(&pi);
   }

template <class T>
XtWorkProcId addWorkProc(T *obj,
			 Boolean (T::*func)(XtPointer),
			 XtAppContext ac,
			 XtPointer closure = NULL)
{
    WorkInfo<T> *pwi = new WorkInfo<T>;

    if (pwi == NULL) return((XtWorkProcId)0);

    pwi->_target     = obj;
    pwi->_callback   = func;
    pwi->_closure    = closure;

    return registerWorkProc(pwi, ac);
}

template <class T>
XtIntervalId addTimeOut(T *obj,
			void (T::*func)(XtPointer, XtIntervalId *),
			XtAppContext ac,
			unsigned long interval,
			XtPointer closure = NULL)
{
    TimerInfo<T> *pti = new TimerInfo<T>;

    if (pti == NULL) return((XtIntervalId)0);

    pti->_target     = obj;
    pti->_callback   = func;
    pti->_closure    = closure;

    return registerTimeOut(pti, ac, interval);
}

template <class T>
XtInputId addInput(T *obj,
		   void (T::*func)(XtPointer, int *, XtInputId *),
		   XtAppContext ac,
		   int source,
		   XtPointer condition,
		   XtPointer closure = NULL)
{
    InputInfo<T> *pii = new InputInfo<T>;

    if (pii == NULL) return((XtInputId)0);

    pii->_target     = obj;
    pii->_callback   = func;
    pii->_closure    = closure;

    return registerInput(pii, ac, source, condition);
}

template <class T>
void addEventHandler(T *obj,
		     void (T::*func)(Widget, XtPointer, XEvent *, Boolean *),
		     Widget w,
		     EventMask em,
		     Boolean n_maskable,
		     XtPointer closure = NULL)
{
    EventInfo<T> *pei = new EventInfo<T>;

    pei->_target      = obj;
    pei->_callback    = func;
    pei->_closure     = closure;
    pei->_widget      = w;
    pei->_em          = em;
    pei->_nonmaskable = n_maskable;

    registerEventHandler(pei);
}

template <class T>
void removeEventHandler(T *obj,
		     void (T::*func)(Widget, XtPointer, XEvent *, Boolean *),
		     Widget w,
		     EventMask em,
		     Boolean n_maskable,
		     XtPointer closure = NULL)
{
    EventInfo<T> ei;

    ei._target      = obj;
    ei._callback    = func;
    ei._closure     = closure;
    ei._widget      = w;
    ei._em          = em;
    ei._nonmaskable = n_maskable;

    unregisterEventHandler(&ei);
}

#endif
