/* $Id: Label.h,v 1.3 1999/01/15 01:13:39 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_LABEL_H_)
#define _XARM_LABEL_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class LabelClass : public PrimitiveClass {
 protected:
   LabelClass() {} /* only a derived class can make this */

   virtual WidgetClass classPointer() { return xmLabelWidgetClass; }
   /* class name */
   virtual _XtString className() { return (_XtString) "XmLabel"; }
 public:
   /* resources */
   void accelerator(const _XtString str);
   _XtString accelerator() const;
   void acceleratorText(const char *str);
   char *acceleratorText() const;
   void alignment(unsigned char);
   unsigned char alignment() const;
   void fontList(const XmFontList);
   XmFontList fontList() const;
   void labelInsensitivePixmap(Pixmap);
   Pixmap labelInsensitivePixmap() const;
   void labelPixmap(const Pixmap);
   Pixmap labelPixmap() const;
   void labelString(const char *str);
   char *labelString() const;
   void labelType(unsigned char);
   unsigned char labelType() const;
   void marginBottom(Dimension);
   Dimension marginBottom() const;
   void marginHeight(Dimension);
   Dimension marginHeight() const;
   void marginLeft(Dimension);
   Dimension marginLeft() const;
   void marginRight(Dimension);
   Dimension marginRight() const;
   void marginTop(Dimension);
   Dimension marginTop() const;
   void marginWidth(Dimension);
   Dimension marginWidth() const;
   void mnemonic(const KeySym);
   KeySym mnemonic() const;
   void mnemonicCharSet(const _XtString);
   _XtString mnemonicCharSet() const;
   void recomputeSize(Boolean); 
   Boolean recomputeSize() const;
   void stringDirection(const XmStringDirection);
   XmStringDirection stringDirection() const;
};

class Label : public LabelClass {
 public:
   Label(Widget w_parent, const char *str, _XtString name = NULL);
   Label(Widget w_parent, 
         ArgList arglist = NULL, 
         Cardinal cnt = 0, 
         _XtString name = NULL);
   Label(_XtString name, Widget w_parent); 
   Label(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
