/* $Id: M2ComboBox.h,v 1.3 1999/01/15 01:32:05 glgay Exp $ */
/*
 Copyright (C) 1997 Gerald L. Gay
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xm/ComboBox.h>

class ComboBoxClass : public ManagerClass {
 protected:
   ComboBoxClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmComboBoxWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmComboBox"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   void selectionCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */
   void arrowSize(Dimension);
   Dimension arrowSize() const;
   void arrowSpacing(Dimension);
   Dimension arrowSpacing() const;
   void highlightThickness(Dimension);
   Dimension highlightThickness() const;
   void fontList(const XmFontList);
   XmFontList fontList() const;
   void matchBehavior(unsigned char);
   unsigned char matchBehavior() const;
   void renderTable(const XmRenderTable);
   XmRenderTable renderTable() const;
   unsigned char comboBoxType() const;  /* read only resource after construction */
   void marginHeight(Dimension);
   Dimension marginHeight() const;
   void marginWidth(Dimension);
   Dimension marginWidth() const;
   void selectedItem(const char *); /* notice this takes char * not XmString */
   char *selectedItem() const; /* notice this returns char * not XmString */
   void selectedPosition(int);
   int selectedPosition() const;

   /* convenience routines */
   /* The add and clear functions were added as    */
   /* convenience routines here by popular demand. */
   Widget list() const; /* return list widget */
   void update(); /* update combobox internal structs */
   void add(const char *); /* Add an item to the list */
   void clear();     /* Clear the list */
   
   /* extra functionality */
   /* 
    * listObject()
    * This routine returns the list wrapper object for the list widget. 
    * Warning: if you modify anything in this object don't forget to 
    * call the update function.
    */
   ListClass *listObject() const; 
   
};

class ComboBox : public ComboBoxClass {

 public:
   ComboBox(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   ComboBox(_XtString name, Widget p);
   ComboBox(Widget w_parent, XarmArg &args, _XtString name);
};


class DropDownList : public ComboBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   DropDownList(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   DropDownList(_XtString name, Widget p);
   DropDownList(Widget w_parent, XarmArg &args, _XtString name);
};

class DropDownComboBox : public ComboBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   DropDownComboBox(Widget p, 
            ArgList arglist = NULL, 
            Cardinal cnt = 0, 
            _XtString name = NULL); 
   DropDownComboBox(_XtString name, Widget p);
   DropDownComboBox(Widget w_parent, XarmArg &args, _XtString name);
};

