/* $Id: Property.h,v 1.3 1999/02/03 13:50:21 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_PROPERTY_H_)
#define _XARM_PROPERTY_H_

/*
 * Warning:  These classes diverge from the Motif 1.2 standard GUI and 
 * use widgets written by the author.
 */

/* ======================================================================= */
/* Include(s): */
#include <Xmext/Property.h>
#include <Xarm/BulletinB.h>

class PropertySheetClass : public BulletinBoardClass {
 protected:
   PropertySheetClass() {} 
   virtual WidgetClass classPointer() { return xmPropertySheetWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmPropertySheet"; }
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   /* callbacks */
   /* activate callbacks for the following default buttons */
   void cancelCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void okCallback(XtCallbackProc fp, XtPointer udata = NULL);
   void applyCallback(XtCallbackProc fp, XtPointer udata = NULL);

   /* resources */
   int pageCount() const; /* return number of pages in the sheet */
   void cancelLabelString(const char *s);  /* changes text of cancel button */
   char *cancelLabelString() const;
   void okLabelString(const char *s);
   char *okLabelString() const;
   void applyLabelString(const char *s);
   char *applyLabelString() const;
   void helpLabelString(const char *s);
   char *helpLabelString() const;

   /* convience routines */
   Widget getPage(int p) const;  /* get page returns a PropertyPage widget */
   void addPage(Widget page, int loc = 0); /* add a PropertyPage widget */
   void removePage(int p); /* remove a page */
   void removePage(Widget page);  /* dito */

   Widget getChild(unsigned char) const;

};

class PropertySheet : public PropertySheetClass {
 public:
   PropertySheet(Widget w_parent, 
                 ArgList arglist = NULL, 
                 Cardinal cnt = 0, 
                 _XtString name = NULL);
   PropertySheet(_XtString name, Widget w_parent); 
   PropertySheet(Widget w_parent, XarmArg &args, _XtString name);
};

class PropertySheetDialog : public PropertySheetClass {
 protected:
   Widget createWidget(_XtString name,
                       Widget w_parent,
                       ArgList arglist = NULL,
                       Cardinal cnt = 0);
 public:
   PropertySheetDialog(Widget w_parent, 
                 ArgList arglist = NULL, 
                 Cardinal cnt = 0, 
                 _XtString name = NULL);
   PropertySheetDialog(_XtString name, Widget w_parent); 
   PropertySheetDialog(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
