/* $Id: Scale.h,v 1.3 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_SCALE_H_)
#define _XARM_SCALE_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class ScaleClass : public ManagerClass {
 protected:
   ScaleClass() {}
   virtual WidgetClass classPointer() { return xmScaleWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmScale"; }
 public:
   /* callbacks */
   void dragCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL); 

   /* resources */
   void decimalPoints(short);
   short decimalPoints() const;
   void fontList(const XmFontList);
   XmFontList fontList() const;
   void highlightOnEnter(Boolean);
   Boolean highlightOnEnter() const;
   void highlightThickness(Dimension);
   Dimension highlightThickness() const;
   void maximum(int);    
   int maximum() const;    
   void minimum(int);    
   int minimum() const;    
   void orientation(unsigned char);
   unsigned char orientation() const;
   void processingDirection(unsigned char);
   unsigned char processingDirection() const;
   void scaleHeight(Dimension);
   Dimension scaleHeight() const;
   void scaleMultiple(int);
   int scaleMultiple() const;
   void scaleWidth(Dimension);
   Dimension scaleWidth() const;
   void showValue(Boolean);
   Boolean showValue() const;
   void titleString(const char *);
   char *titleString() const;
   void value(int);
   int value() const;
};

class Scale : public ScaleClass {
 public:
   Scale(Widget w_parent, 
         ArgList arglist = NULL,
         Cardinal cnt = 0,
         _XtString name = NULL);
   Scale(_XtString name, Widget w_parent);
   Scale(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
