/* $Id: ScrolledW.h,v 1.4 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_SCROLLEDW_H_)
#define _XARM_SCROLLEDW_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class ScrolledWindowClass: public ManagerClass {
 protected:
   ScrolledWindowClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmScrolledWindowWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmScrolledWindow"; }
 public:
   /* callbacks */
   void traverseObscuredCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* resources */
   Widget horizontalScrollBar() const;
   void horizontalScrollBar(Widget);
   void scrollBarDisplayPolicy(unsigned char); 
   unsigned char scrollBarDisplayPolicy() const; 
   void scrollBarPlacement(unsigned char);
   unsigned char scrollBarPlacement() const;
   void scrolledWindowMarginHeight(Dimension);
   Dimension scrolledWindowMarginHeight() const;
   void scrolledWindowMarginWidth(Dimension);
   Dimension scrolledWindowMarginWidth() const;
   unsigned char scrollingPolicy() const; 
   void spacing(int);
   int spacing() const;
   Widget verticalScrollBar() const;
   void verticalScrollBar(Widget);
   unsigned char visualPolicy() const;
   void workWindow(Widget);
   Widget workWindow() const;

   /* convenience routines */
   void setArea(Widget hscroll, Widget vscroll, Widget work);
};

class ScrolledWindow : public ScrolledWindowClass {
 public:
   ScrolledWindow(Widget w_parent,
                  ArgList arglist = NULL,
                  Cardinal cnt = 0,
                  _XtString name = NULL);
   ScrolledWindow(_XtString name, Widget w_parent);
   ScrolledWindow(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
