/* $Id: Text.h,v 1.3 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_TEXT_H_)
#define _XARM_TEXT_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Primitive.h>

class TextClass : public PrimitiveClass {
 protected:
   TextClass() {}
   virtual WidgetClass classPointer() { return xmTextWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmText"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void focusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void gainPrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losePrimaryCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void losingFocusCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void modifyVerifyCallbackWcs(XtCallbackProc funcp, XtPointer data = NULL);
   void motionVerifyCallback(XtCallbackProc funcp, XtPointer data = NULL);
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL);

   /* convient functions */
   void clearSelection(Time time);
   Boolean copy(Time t);
   Boolean cut(Time t);
   void disableRedisplay();
   void enableRedisplay();
   Boolean findString(XmTextPosition start, const char *str, 
                         XmTextDirection direction, XmTextPosition *pos);
   Boolean findStringWcs(XmTextPosition start, const wchar_t *wcs, 
                         XmTextDirection direction, XmTextPosition *pos);
   int getBaseline() const;
   XmTextPosition getCursorPosition() const;
   Boolean getEditable() const;
   XmTextPosition getInsertionPosition() const;
   XmTextPosition getLastPosition() const;
   int getMaxLength() const;
   char *getSelection() const;
   Boolean getSelectionPosition(XmTextPosition *left, XmTextPosition *right);
   wchar_t *getSelectionWcs() const;
   XmTextSource getSource() const;
   char *getString() const;
   wchar_t *getStringWcs() const;
   int getSubstring(XmTextPosition start, int no_chars, int buf_sz, char *buf);
   int getSubstringWcs(XmTextPosition start, int no_chars, int buf_sz, 
                       wchar_t *buf);
   XmTextPosition getTopCharacter() const;
   void insert(XmTextPosition pos, const char *str);
   void insertWcs(XmTextPosition pos, const wchar_t *str);
   Boolean paste() const;
   Boolean posToXY(XmTextPosition pos, Position *xpos, Position *ypos);
   Boolean remove();
   void replace(XmTextPosition from, XmTextPosition to, const char *val);
   void replaceWcs(XmTextPosition from, XmTextPosition to, const wchar_t *val);
   void scroll(int lines);
   void setAddMode(Boolean state);
   void setCursorPosition(const XmTextPosition pos);
   void setEditable(Boolean edit);
   void setHighlight(XmTextPosition left, XmTextPosition right,
                     XmHighlightMode mode);
   void setInsertionPosition(const XmTextPosition pos);
   void setMaxLength(int max);
   void setSelection(XmTextPosition first, XmTextPosition last,
                     Time t);
   void setSource(XmTextSource src, XmTextPosition top, XmTextPosition cursor);
   void setString(const char *str);
   void setStringWcs(const wchar_t *str);
   void setTopCharacter(const XmTextPosition top);
   void showPosition(const XmTextPosition pos);
   XmTextPosition xyToPos(Position xpos, Position ypos) const;

   /* resources */
   void autoShowCursorPosition(Boolean);
   Boolean autoShowCursorPosition() const;
   void blinkRate(int);
   int blinkRate() const;
   void columns(short);
   short columns() const;
   void cursorPosition(const XmTextPosition);
   XmTextPosition cursorPosition() const;
   void cursorPositionVisible(Boolean);
   Boolean cursorPositionVisible() const;
   void editable(Boolean);
   Boolean editable() const;
   void editMode(int);
   int editMode() const;
   void fontList(const XmFontList);
   XmFontList fontList() const;
   void marginHeight(Dimension);
   Dimension marginHeight() const;
   void marginWidth(Dimension);
   Dimension marginWidth() const;
   void maxLength(int);
   int maxLength() const;
   void pendingDelete(Boolean);
   Boolean pendingDelete() const;
   void resizeHeight(Boolean);
   Boolean resizeHeight() const;
   void resizeWidth(Boolean);
   Boolean resizeWidth() const;
   void rows(short);
   short rows() const;
   void selectionArray(const XmTextScanType *);
   XmTextScanType *selectionArray() const;
   void selectionArrayCount(int);
   int selectionArrayCount() const;
   void selectThreshold(int);
   int selectThreshold() const;
   void source(XmTextSource);
   XmTextSource source() const;
   void topCharacter(XmTextPosition);
   XmTextPosition topCharacter() const;
   void value(const _XtString);
   _XtString value() const;
   void valueWcs(const wchar_t *);
   wchar_t *valueWcs() const;
   void verifyBell(Boolean);
   Boolean verifyBell() const;
   void wordWrap(Boolean);
   Boolean wordWrap() const;
};

class ScrolledTextClass : public TextClass {
 protected:
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
   ScrolledTextClass() {}
 public:
   void scrollHorizontal(Boolean);
   Boolean scrollHorizontal() const;
   void scrollLeftSide(Boolean);
   Boolean scrollLeftSide() const;
   void scrollTopSide(Boolean);
   Boolean scrollTopSide() const;
   void scrollVertical(Boolean);
   Boolean scrollVertical() const;
};

class Text : public TextClass {
 public:
   Text(Widget w_parent, 
        ArgList arglist = NULL,
        Cardinal cnt = 0,
        _XtString name = NULL);
   Text(_XtString name, Widget w_parent);
   Text(Widget w_parent, XarmArg &args, _XtString name);
};

class ScrolledText : public ScrolledTextClass {
 public:
   ScrolledText(Widget w_parent,
                ArgList arglist = NULL,
                Cardinal cnt = 0,
                _XtString name = NULL);
   ScrolledText(_XtString name, Widget w_parent);
   ScrolledText(Widget w_parent, XarmArg &args, _XtString name);
};


#endif
