/* $Id: ToggleB.h,v 1.4 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_TOGGLEB_H_)
#define _XARM_TOGGLEB_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Label.h>

class ToggleButtonClass : public LabelClass {
 protected:
   ToggleButtonClass() {}

   /* class pointer */
   virtual WidgetClass classPointer() { return xmToggleButtonWidgetClass; }
   /* class name */
   virtual _XtString className() { return (_XtString) "XmToggleButton"; }
 public:
   /* callbacks */
   void armCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void disarmCallback(XtCallbackProc funcp, XtPointer data = NULL); 
   void valueChangedCallback(XtCallbackProc funcp, XtPointer data = NULL); 

   /* convenience */
   Boolean getState() const;
   void setState(Boolean state, Boolean notify = FALSE);

   /* resources */
   void fillOnSelect(Boolean);
   Boolean fillOnSelect() const;
   void indicatorOn(Boolean);
   Boolean indicatorOn() const;
   void indicatorSize(Dimension);
   Dimension indicatorSize() const;
   void indicatorType(unsigned char);
   unsigned char indicatorType() const;
   void selectColor(Pixel);
   Pixel selectColor() const;
   void selectInsensitivePixmap(Pixmap);
   Pixmap selectInsensitivePixmap() const;
   void set(Boolean);
   Boolean set() const;
   void spacing(Dimension);
   Dimension spacing() const;
   void visibleWhenOff(Boolean);
   Boolean visibleWhenOff() const;

   // Additional functionality
   void selectColor(const char *);
};
   
class ToggleButton : public ToggleButtonClass {
 public:
   ToggleButton(Widget w_parent, 
                char *text, 
                KeySym mn = 0, 
                _XtString acc = NULL, 
                char *acc_text = NULL, 
                _XtString name = NULL);
   ToggleButton(Widget w_parent,
                ArgList arglist = NULL, 
                Cardinal cnt = 0, 
                _XtString name = NULL);
   ToggleButton(_XtString name, Widget w_parent);
   ToggleButton(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
