/*
 Copyright (C) 1997, Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(_XARMARG_H)
#define _XARMARG_H

#include <vector>
#include <X11/Intrinsic.h>

struct typedArg {
    String    resource_name;
    String    type_name;
    XtPointer value;
    unsigned  val_size;
};

class XarmArg {

private:

    vector<Arg>      argVec;
    vector<typedArg> typedArgVec;

    ArgList theArgs;

    unsigned int sizeOfType(String);

    // Avoid copying

    XarmArg &operator=(const XarmArg &);
    XarmArg(const XarmArg &);

public:

    XarmArg() : theArgs(NULL) {}
    ~XarmArg() { delete [] theArgs; }

    Cardinal count()  { return argVec.size(); }
    void     reset();
    ArgList  getArgs();
    void     setTypedArgs(Widget);
    bool     hasTypedArgs() { return (typedArgVec.size() > 0); }

    XarmArg &operator()(String, XtArgVal);
    XarmArg &operator()(String, String, XtPointer, unsigned int);
    XarmArg &operator()(String name, XtPointer      value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, signed   int   value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, unsigned int   value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, unsigned long  value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, signed   char  value) { return operator()(name, (XtArgVal)value); }
    XarmArg &operator()(String name, unsigned char  value) { return operator()(name, (XtArgVal)value); }
};

#endif
