/* $Id: PanedW.C,v 1.4 1999/02/03 13:50:22 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


/* Include(s): */
#include <Xarm/PanedW.h>

/* PanedWindowClass members */
/* resources */
void PanedWindowClass::marginHeight(Dimension v)
{
   XtVaSetValues(widget(),XmNmarginHeight, v, NULL);
}

Dimension PanedWindowClass::marginHeight() const
{
   Dimension v;
   XtVaGetValues(widget(),XmNmarginHeight, &v, NULL);
   return v;
}

void PanedWindowClass::marginWidth(Dimension v)
{
   XtVaSetValues(widget(),XmNmarginWidth, v, NULL);
}

Dimension PanedWindowClass::marginWidth() const
{
   Dimension v;
   XtVaGetValues(widget(),XmNmarginWidth, &v, NULL);
   return v;
}

void PanedWindowClass::refigureMode(Boolean v)
{
   XtVaSetValues(widget(),XmNrefigureMode, v, NULL);
}

Boolean PanedWindowClass::refigureMode() const
{
   Boolean v;
   XtVaGetValues(widget(),XmNrefigureMode, &v, NULL);
   return v;
}

void PanedWindowClass::sashHeight(Dimension v)
{
   XtVaSetValues(widget(),XmNsashHeight, v, NULL);
}

Dimension PanedWindowClass::sashHeight() const
{
   Dimension v;
   XtVaGetValues(widget(),XmNsashHeight, &v, NULL);
   return v;
}

void PanedWindowClass::sashIndent(Position v)
{
   XtVaSetValues(widget(),XmNsashIndent, v, NULL);
}

Position PanedWindowClass::sashIndent() const
{
   Position v;
   XtVaGetValues(widget(),XmNsashIndent, &v, NULL);
   return v;
}

void PanedWindowClass::sashShadowThickness(Dimension v)
{
   XtVaSetValues(widget(),XmNsashShadowThickness, v, NULL);
}

Dimension PanedWindowClass::sashShadowThickness() const
{
   Dimension v;
   XtVaGetValues(widget(),XmNsashShadowThickness, &v, NULL);
   return v;
}

void PanedWindowClass::sashWidth(Dimension v)
{
   XtVaSetValues(widget(),XmNsashWidth, v, NULL);
}

Dimension PanedWindowClass::sashWidth() const
{
   Dimension v;
   XtVaGetValues(widget(),XmNsashWidth, &v, NULL);
   return v;
}

void PanedWindowClass::separatorOn(Boolean v)
{
   XtVaSetValues(widget(),XmNseparatorOn, v, NULL);
}

Boolean PanedWindowClass::separatorOn() const
{
   Boolean v;
   XtVaGetValues(widget(),XmNseparatorOn, &v, NULL);
   return v;
}

void PanedWindowClass::spacing(Dimension v)
{
   XtVaSetValues(widget(),XmNspacing, v, NULL);
}

Dimension PanedWindowClass::spacing() const
{
   Dimension v;
   XtVaGetValues(widget(),XmNspacing, &v, NULL);
   return v;
}

PanedWindow::PanedWindow(Widget w_parent,
                         ArgList arglist,
                         Cardinal cnt,
                         _XtString name)
{
   Widget wid = createWidget(name, w_parent, arglist, cnt);
   widget(wid);
}

PanedWindow::PanedWindow(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(wid);
   widget(wid);
}

PanedWindow::PanedWindow(_XtString name, Widget w_parent)
{
   Widget wid = createWidget(name, w_parent);
   widget(wid);
}

/* */
