/* $Id: Separator.C,v 1.4 1999/02/03 13:50:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Separator.h>
/* SeparatorClass member functions */

void 
SeparatorClass::margin(Dimension m)
{
   XtVaSetValues(widget(), XmNmargin, m, NULL);
}

Dimension
SeparatorClass::margin() const
{
   Dimension d;
   XtVaGetValues(widget(), XmNmargin, &d, NULL);
   return d;
}

void 
SeparatorClass::orientation(unsigned char o)
{
   XtVaSetValues(widget(), XmNorientation, o, NULL);
}

unsigned char
SeparatorClass::orientation() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNorientation, &c, NULL);
   return c;
}

void 
SeparatorClass::separatorType(unsigned char s)
{
   XtVaSetValues(widget(), XmNseparatorType, s, NULL);
}

unsigned char
SeparatorClass::separatorType() const
{
   unsigned char c;
   XtVaGetValues(widget(), XmNseparatorType, &c, NULL);
   return c;
}

/* constructors */
Separator::Separator(Widget w_parent,
                     ArgList arglist,
                     Cardinal cnt,
                     _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt); 
   widget(w);
   manage();
}

Separator::Separator(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
   manage();
}

Separator::Separator(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent); 
   widget(w);
   manage();
}

/* */
