/* $Id: WMShell.C,v 1.2 1999/02/03 13:50:23 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Shell.h>

/* WMShellClass Members */

/* resources */
void
WMShellClass::baseHeight(int v)
{
   XtVaSetValues(widget(),XmNbaseHeight, v, NULL);
}

int
WMShellClass::baseHeight() const
{
   int v;
   XtVaGetValues(widget(),XmNbaseHeight, &v, NULL);
   return v;
}

void
WMShellClass::baseWidth(int v)
{
   XtVaSetValues(widget(),XmNbaseWidth, v, NULL);
}

int
WMShellClass::baseWidth() const
{
   int v;
   XtVaGetValues(widget(),XmNbaseWidth, &v, NULL);
   return v;
}

void
WMShellClass::heightInc(int v)
{
   XtVaSetValues(widget(),XmNheightInc, v, NULL);
}

int
WMShellClass::heightInc() const
{
   int v;
   XtVaGetValues(widget(),XmNheightInc, &v, NULL);
   return v;
}

void
WMShellClass::iconMask(Pixmap p)
{
   XtVaSetValues(widget(),XmNiconMask, p, NULL);
}

Pixmap
WMShellClass::iconMask() const
{
   Pixmap p;
   XtVaGetValues(widget(),XmNiconMask, &p, NULL);
   return p;
}

void
WMShellClass::iconPixmap(Pixmap p)
{
   XtVaSetValues(widget(),XmNiconPixmap, p, NULL);
}

Pixmap
WMShellClass::iconPixmap() const
{
   Pixmap p;
   XtVaGetValues(widget(),XmNiconPixmap, &p, NULL);
   return p;
}

void
WMShellClass::iconWindow(Window w)
{
   XtVaSetValues(widget(),XmNiconWindow, w, NULL);
}

Window
WMShellClass::iconWindow() const
{
   Window w;
   XtVaGetValues(widget(),XmNiconWindow, &w, NULL);
   return w;
}

void
WMShellClass::iconX(int i)
{
   XtVaSetValues(widget(),XmNiconX, i, NULL);
}

int
WMShellClass::iconX() const
{
   int i;
   XtVaGetValues(widget(),XmNiconX, &i, NULL);
   return i;
}

void
WMShellClass::iconY(int i)
{
   XtVaSetValues(widget(),XmNiconY, i, NULL);
}

int
WMShellClass::iconY() const
{
   int i;
   XtVaGetValues(widget(),XmNiconY, &i, NULL);
   return i;
}

void
WMShellClass::initialState(int i)
{
   XtVaSetValues(widget(),XmNinitialState, i, NULL);
}

int
WMShellClass::initialState() const
{
   int i;
   XtVaGetValues(widget(),XmNinitialState, &i, NULL);
   return i;
}

void
WMShellClass::input(Boolean b)
{
   XtVaSetValues(widget(),XmNinput, b, NULL);
}

Boolean
WMShellClass::input() const
{
   Boolean b;
   XtVaGetValues(widget(),XmNinput, &b, NULL);
   return b;
}

void
WMShellClass::maxAspectX(int i)
{
   XtVaSetValues(widget(), XmNmaxAspectX, i, NULL);   
}

int
WMShellClass::maxAspectX() const
{
   int i;
   XtVaGetValues(widget(), XmNmaxAspectX, &i, NULL);   
   return i;
}

void
WMShellClass::maxAspectY(int i)
{
   XtVaSetValues(widget(), XmNmaxAspectY, i, NULL);   
}

int
WMShellClass::maxAspectY() const
{
   int i;
   XtVaGetValues(widget(), XmNmaxAspectY, &i, NULL);   
   return i;
}

void
WMShellClass::maxHeight(int i)
{
   XtVaSetValues(widget(), XmNmaxHeight, i, NULL);   
}

int
WMShellClass::maxHeight() const
{
   int i;
   XtVaGetValues(widget(), XmNmaxHeight, &i, NULL);   
   return i;
}

void
WMShellClass::maxWidth(int i)
{
   XtVaSetValues(widget(), XmNmaxWidth, i, NULL);   
}

int
WMShellClass::maxWidth() const
{
   int i;
   XtVaGetValues(widget(), XmNmaxWidth, &i, NULL);   
   return i;
}

void
WMShellClass::minAspectX(int i)
{
   XtVaSetValues(widget(), XmNminAspectX, i, NULL);   
}

int
WMShellClass::minAspectX() const
{
   int i;
   XtVaGetValues(widget(), XmNminAspectX, &i, NULL);   
   return i;
}

void
WMShellClass::minAspectY(int i)
{
   XtVaSetValues(widget(), XmNminAspectY, i, NULL);   
}

int
WMShellClass::minAspectY() const
{
   int i;
   XtVaGetValues(widget(), XmNminAspectY, &i, NULL);   
   return i;
}

void
WMShellClass::minHeight(int i)
{
   XtVaSetValues(widget(), XmNminHeight, i, NULL);   
}

int
WMShellClass::minHeight() const
{
   int i;
   XtVaGetValues(widget(), XmNminHeight, &i, NULL);   
   return i;
}

void
WMShellClass::minWidth(int i)
{
   XtVaSetValues(widget(), XmNminWidth, i, NULL);   
}

int
WMShellClass::minWidth() const
{
   int i;
   XtVaGetValues(widget(), XmNminWidth, &i, NULL);   
   return i;
}

void
WMShellClass::title(const _XtString s)
{
   XtVaSetValues(widget(), XmNtitle, s, NULL);
}

_XtString
WMShellClass::title() const
{
   _XtString s;
   XtVaGetValues(widget(), XmNtitle, &s, NULL);
   return s;
}

void
WMShellClass::titleEncoding(Atom a)
{
   XtVaSetValues(widget(), XmNtitleEncoding, a, NULL);
}

Atom
WMShellClass::titleEncoding() const
{
   Atom a;
   XtVaGetValues(widget(), XmNtitleEncoding, &a, NULL);
   return a;
}

void 
WMShellClass::transient(Boolean b)
{
   XtVaSetValues(widget(), XmNtransient, b, NULL);
}

Boolean
WMShellClass::transient() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNtransient, &b, NULL);
   return b;
}

void
WMShellClass::waitForWm(Boolean b)
{
   XtVaSetValues(widget(), XmNwaitForWm, b, NULL);
}

Boolean
WMShellClass::waitForWm() const
{
   Boolean b;
   XtVaGetValues(widget(), XmNwaitForWm, &b, NULL);
   return b;
}

void
WMShellClass::widthInc(int i)
{
   XtVaSetValues(widget(), XmNwidthInc, i, NULL);
}

int
WMShellClass::widthInc() const
{
   int i;
   XtVaGetValues(widget(), XmNwidthInc, &i, NULL);
   return i;
}

void
WMShellClass::windowGroup(Window w)
{
   XtVaSetValues(widget(), XmNwindowGroup, w, NULL);
}

Window
WMShellClass::windowGroup() const
{
   Window w;
   XtVaGetValues(widget(), XmNwindowGroup, &w, NULL);
   return w;
}

void
WMShellClass::winGravity(int i)
{
   XtVaSetValues(widget(), XmNwinGravity, i, NULL);
}

int
WMShellClass::winGravity() const
{
   int i;
   XtVaGetValues(widget(), XmNwinGravity, &i, NULL);
   return i;
}

void
WMShellClass::wmTimeout(int i)
{
   XtVaSetValues(widget(), XmNwmTimeout, i, NULL);
}

int
WMShellClass::wmTimeout() const
{
   int i;
   XtVaGetValues(widget(), XmNwmTimeout, &i, NULL);
   return i;
}


