/*
 Copyright (C) 1999, Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Xarm.h>

#ifdef XARM_HAS_XBAE

#include <Xarm/XarmCaption.h>

void CaptionClass::fontList(const XmFontList f)
{
    XtVaSetValues(widget(), XmNfontList, f, NULL);
}

XmFontList CaptionClass::fontList() const
{
    XmFontList f;

    XtVaGetValues(widget(), XmNfontList, &f, NULL);

    return f;
}

void CaptionClass::labelAlignment(XbaeLabelAlignment a)
{
    XtVaSetValues(widget(), XmNlabelAlignment, a, NULL);
}

XbaeLabelAlignment CaptionClass::labelAlignment() const
{
    XbaeLabelAlignment a;

    XtVaGetValues(widget(), XmNlabelAlignment, &a, NULL);

    return a;
}

void CaptionClass::labelOffset(int lo)
{
    XtVaSetValues(widget(), XmNlabelOffset, lo, NULL);
}

int CaptionClass::labelOffset() const
{
    int lo;

    XtVaGetValues(widget(), XmNlabelOffset, &lo, NULL);

    return lo;
}

void CaptionClass::labelPixmap(Pixmap p)
{
    XtVaSetValues(widget(), XmNlabelPixmap, p, NULL);
}

Pixmap CaptionClass::labelPixmap() const
{
    Pixmap p;

    XtVaGetValues(widget(), XmNlabelPixmap, &p, NULL);

    return p;
}

void CaptionClass::labelPosition(XbaeLabelPosition lp)
{
    XtVaSetValues(widget(), XmNlabelPosition, lp, NULL);
}

XbaeLabelPosition CaptionClass::labelPosition() const
{
    XbaeLabelPosition lp;

    XtVaGetValues(widget(), XmNlabelPosition, &lp, NULL);

    return lp;
}

void CaptionClass::labelString(const char *ls)
{
    XmString str;

    str = cvtStringToXmString(ls);

    XtVaSetValues(widget(), XmNlabelString, str, NULL);

    XmStringFree(str);
}

char *CaptionClass::labelString() const
{
    XmString str;

    XtVaGetValues(widget(), XmNlabelString, &str, NULL);

    return cvtXmStringToString(str);
}

void CaptionClass::labelTextAlignment(Alignment a)
{
    XtVaSetValues(widget(), XmNlabelTextAlignment, a, NULL);
}

Alignment CaptionClass::labelTextAlignment() const
{
    Alignment a;

    XtVaGetValues(widget(), XmNlabelTextAlignment, &a, NULL);

    return a;
}

void CaptionClass::labelType(unsigned char ch)
{
    XtVaSetValues(widget(), XmNlabelType, ch, NULL);
}

unsigned char CaptionClass::labelType() const
{
    unsigned char ch;

    XtVaGetValues(widget(), XmNlabelType, &ch, NULL);

    return ch;
}

Caption::Caption(Widget w_parent, ArgList arglist, Cardinal cnt, _XtString name)
{
    Widget wid = createWidget(name, w_parent, arglist, cnt);
    widget(wid);
}

Caption::Caption(_XtString name, Widget w_parent)
{
    Widget wid = createWidget(name, w_parent);
    widget(wid);
}

Caption::Caption(Widget w_parent, XarmArg &args, _XtString name)
{
    Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
    if (args.hasTypedArgs()) args.setTypedArgs(wid);
    widget(wid);
}

#endif // XARM_HAS_XBAE
