#!/bin/sh
#
# A simple script to fix up sizes.
#

#
# Figure out what version of the Xarm tar file we have.
# (it may still be a beta)
#

TARBALL=`ls Xarm-1.4.0*tar.gz 2>/dev/null`

if [ -z "$TARBALL" ]; then
    TARBALL=`ls ../../../Xarm-1.4.0*tar.gz | cut -d/ -f4 2>/dev/null`
fi

if [ -z "$TARBALL" ]; then
    echo "Couldn't find the Xarm tar file!"
    echo "Please make sure that either Xarm-1.4.0.tar.gz is"
    echo "in the XarmSetup directory or is immediately above"
    echo "the Xarm source directory."
    exit 1
fi

if [ ! -f $TARBALL ]; then
    cp ../../../$TARBALL .
fi

TSIZE=`ls -l $TARBALL | awk '{print $5}'`
TCOUNT=`gzip -cd $TARBALL | tar tvf - | wc | awk '{print $1}'`
sed -e "s/= A/= $TSIZE/g" -e "s/= B/= $TCOUNT/g" sizes_t.C > sizes.C
echo "char *XarmTarballName=\"$TARBALL\";" >> sizes.C
