/* $Id: xdial.C,v 1.3 1999/11/06 05:50:56 glgay Exp $ */
/*
 * Copyright (c) 1994, Jettero Heller
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/Form.h>
#include <Xarm/Callback.h>
#include <Xarm/Label.h>
#include <Xarm/RowColumn.h>
#include <Xarm/MessageB.h>
#include <Xarm/Scale.h>
#include <Xarm/XarmArg.h>
#include <Xmext/Dial.h>
#include "xdial.h"

int main (int argc, char **argv)
{
   // initialize application 
   DialDemo app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

DialDemo::DialDemo(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(),proto,(p_msg)&onExit);

   title(app_class);

   // install window(s) into the application window 

   XarmArg args;

   main_form = new Form(app_class, widget());

   args(XmNtopAttachment,    XmATTACH_FORM)
       (XmNleftAttachment,   XmATTACH_FORM)
       (XmNrightAttachment,  XmATTACH_FORM);

   label = new Label(*main_form, args, "Dial Test"); 
   args.reset();

   args(XmNfractionBase,     5              )
       (XmNtopAttachment,    XmATTACH_WIDGET)
       (XmNleftAttachment,   XmATTACH_FORM  )
       (XmNrightAttachment,  XmATTACH_FORM  )
       (XmNtopWidget,        label->widget());

   dial_form = new Form(*main_form, args, app_class);
   args.reset();

   args(XmNtopAttachment,       XmATTACH_FORM    )
       (XmNleftAttachment,      XmATTACH_FORM    )
       (XmNrightAttachment,     XmATTACH_POSITION)
       (XmNrightPosition,       2                )
       (XmNminimum,             0                )
       (XmNmaximum,             100              )
       (XmNvalue,               0                )
       (XmNtickIncrement,       5                )
       (XmNtickSize,            10               )
       (XmNarcMargin,           7                )
       (XmNborderMargin,        0                )
       (XmNprocessingDirection, XmMAX_ON_RIGHT   )
       (XmNfill,                True             )
       (XmNshowValue,           True             )
       (XmNshowPercentage,      True             )
       (XmNshowHub,             True             )
       (XmNstyle,               PointerStyle     )
       (XmNheight,              160              )
       (XmNwidth,               235              )
       (XmNforeground, XmRString, "blue",  5     )
       (XmNbackground, XmRString, "white", 6     );
  
    dials.push_back(new Dial(*dial_form, args, "dial"));
    args.reset();

    args(XmNtopAttachment,       XmATTACH_FORM    )
        (XmNrightAttachment,     XmATTACH_FORM    )
        (XmNleftAttachment,      XmATTACH_POSITION)
        (XmNleftPosition,        3                )
        (XmNminimum,             0                )
        (XmNmaximum,             100              )
        (XmNvalue,               0                )
        (XmNtickIncrement,       5                )
        (XmNtickSize,            10               )
        (XmNarcMargin,           7                )
        (XmNborderMargin,        0                )
        (XmNprocessingDirection, XmMAX_ON_LEFT    )
        (XmNfill,                False            )
        (XmNshowValue,           True             )
        (XmNshowPercentage,      False            )
        (XmNshowHub,             False            )
        (XmNstyle,               PointerStyle     )
        (XmNheight,              160              )
        (XmNwidth,               235              )
        (XmNforeground, XmRString, "white",  6    )
        (XmNbackground, XmRString, "grey50", 7    );

    dials.push_back(new Dial(*dial_form, args, "dial"));
    args.reset();

    args(XmNrightAttachment,     XmATTACH_POSITION  )
        (XmNtopAttachment,       XmATTACH_WIDGET    )
        (XmNrightPosition,       2                  )
        (XmNtopWidget,           dials[0]           )
        (XmNleftAttachment,      XmATTACH_FORM      )
        (XmNbottomAttachment,    XmATTACH_FORM      )
        (XmNminimum,             0                  )
        (XmNmaximum,             100                )
        (XmNvalue,               0                  )
        (XmNtickIncrement,       5                  )
        (XmNtickSize,            10                 )
        (XmNarcMargin,           7                  )
        (XmNborderMargin,        3                  )
        (XmNprocessingDirection, XmMAX_ON_RIGHT     )
        (XmNfill,                False              )
        (XmNshowValue,           True               )
        (XmNshowPercentage,      False              )
        (XmNshowHub,             True               )
        (XmNshowMinMax,          True               )
        (XmNstyle,               MeterStyle         )
        (XmNheight,              140                )
        (XmNwidth,               235                )
        (XmNforeground, XmRString, "lightblue", 10  )
        (XmNbackground, XmRString, "slateblue", 10  );

    dials.push_back(new Dial(*dial_form, args, "dial"));
    args.reset();

    args(XmNleftAttachment,      XmATTACH_POSITION )
        (XmNtopAttachment,       XmATTACH_WIDGET   )
        (XmNleftPosition,        3                 )
        (XmNtopWidget,           dials[1]          )
        (XmNbottomAttachment,    XmATTACH_FORM     )
        (XmNrightAttachment,     XmATTACH_FORM     )
        (XmNminimum,             0                 )
        (XmNmaximum,             100               )
        (XmNvalue,               0                 )
        (XmNtickIncrement,       5                 )
        (XmNtickSize,            10                )
        (XmNarcMargin,           7                 )
        (XmNborderMargin,        3                 )
        (XmNprocessingDirection, XmMAX_ON_LEFT     )
        (XmNfill,                False             )
        (XmNshowValue,           True              )
        (XmNshowPercentage,      True              )
        (XmNshowHub,             False             )
        (XmNshowMinMax,          True              )
        (XmNstyle,               MeterStyle        )
        (XmNheight,              140               )
        (XmNwidth,               235               )
        (XmNforeground, XmRString, "lightblue", 10 )
        (XmNbackground, XmRString, "grey40",    7  );

    dials.push_back(new Dial(*dial_form, args, "dial"));
    args.reset();

    args(XmNtopAttachment,    XmATTACH_FORM    )
        (XmNleftAttachment,   XmATTACH_POSITION)
        (XmNrightAttachment,  XmATTACH_POSITION)
        (XmNleftPosition,     2                )
        (XmNrightPosition,    3                )
        (XmNbottomAttachment, XmATTACH_FORM    )
        (XmNorientation,      XmVERTICAL       );

    rowcol = new RowColumn(*dial_form, args, "rc");
    args.reset();

    args(XmNminimum,             100           )
        (XmNmaximum,             200           )
        (XmNvalue,               100           )
        (XmNtickIncrement,       25            )
        (XmNtickSize,            5             )
        (XmNarcMargin,           3             )
        (XmNborderMargin,        0             )
        (XmNprocessingDirection, XmMAX_ON_RIGHT)
        (XmNfill,                False         )
        (XmNshowValue,           True          )
        (XmNshowPercentage,      True          )
        (XmNshowHub,             True          )
        (XmNstyle,               PointerStyle  )
        (XmNheight,              80            )
        (XmNwidth,               117           )
        (XmNforeground, XmRString, "green", 6  )
        (XmNbackground, XmRString, "black", 6  );
    dials.push_back(new Dial(*rowcol, args, "dial"));
    args.reset();

    args(XmNminimum,             100           )
        (XmNmaximum,             200           )
        (XmNvalue,               100           )
        (XmNtickIncrement,       20            )
        (XmNtickSize,            7             )
        (XmNarcMargin,           3             )
        (XmNborderMargin,        0             )
        (XmNprocessingDirection, XmMAX_ON_LEFT )
        (XmNfill,                True          )
        (XmNshowValue,           True          )
        (XmNshowPercentage,      False         )
        (XmNshowHub,             False         )
        (XmNstyle,               PointerStyle  )
        (XmNheight,              80            )
        (XmNwidth,               117           )
        (XmNforeground, XmRString, "red", 4    )
        (XmNbackground, XmRString, "black", 6  );
    dials.push_back(new Dial(*rowcol, args, "dial"));
    args.reset();

    args(XmNminimum,             100           )
        (XmNmaximum,             200           )
        (XmNvalue,               100           )
        (XmNtickIncrement,       25            )
        (XmNtickSize,            6             )
        (XmNarcMargin,           7             )
        (XmNborderMargin,        3             )
        (XmNprocessingDirection, XmMAX_ON_RIGHT)
        (XmNfill,                True          )
        (XmNshowValue,           True          )
        (XmNshowPercentage,      False         )
        (XmNshowHub,             True          )
        (XmNshowMinMax,          True          )
        (XmNstyle,               MeterStyle    )
        (XmNheight,              80            )
        (XmNwidth,               117           )
        (XmNforeground, XmRString, "blue", 5   )
        (XmNbackground, XmRString, "black", 6  );
    dials.push_back(new Dial(*rowcol, args, "dial"));
    args.reset();

    args(XmNminimum,             100           )
        (XmNmaximum,             200           )
        (XmNvalue,               100           )
        (XmNtickIncrement,       50            )
        (XmNtickSize,            9             )
        (XmNarcMargin,           7             )
        (XmNborderMargin,        3             )
        (XmNprocessingDirection, XmMAX_ON_LEFT )
        (XmNfill,                True          )
        (XmNshowValue,           True          )
        (XmNshowPercentage,      True          )
        (XmNshowHub,             False         )
        (XmNshowMinMax,          True          )
        (XmNstyle,               MeterStyle    )
        (XmNheight,              80            )
        (XmNwidth,               117           )
        (XmNforeground, XmRString, "yellow", 7 )
        (XmNbackground, XmRString, "black", 6  );
    dials.push_back(new Dial(*rowcol, args, "dial"));
    args.reset();

    args(XmNtopAttachment,       XmATTACH_WIDGET    )
        (XmNleftAttachment,      XmATTACH_FORM      )
        (XmNrightAttachment,     XmATTACH_FORM      )
        (XmNbottomAttachment,    XmATTACH_FORM      )
        (XmNtopWidget,           dial_form          )
        (XmNprocessingDirection, XmMAX_ON_RIGHT     )
        (XmNminimum,             0                  )
        (XmNmaximum,             100                )
        (XmNvalue,               0                  )
        (XmNorientation,         XmHORIZONTAL       );

    scale = new Scale(*main_form, args, "scale");

    addCallback(*scale, XmNvalueChangedCallback, (p_msg)&onInc);
    addCallback(*scale, XmNdragCallback, (p_msg)&onInc);

    scale->manage();
    rowcol->manage();
    dial_form->manage();
    main_form->manage();
}

void DialDemo::exit(Widget, XtPointer, XtPointer)
{
   quit();
}

void DialDemo::onInc(Widget, XtPointer, XtPointer)
{
    dials[0]->value(scale->value());
    dials[1]->value(scale->value());
    dials[2]->value(scale->value());
    dials[3]->value(scale->value());
    dials[4]->value(scale->value() + 100);
    dials[5]->value(scale->value() + 100);
    dials[6]->value(scale->value() + 100);
    dials[7]->value(scale->value() + 100);
}
    

void DialDemo::onExit(Widget w, XtPointer, XtPointer)
{
   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");

   diag->dialogTitle("Exit Dialog");
   addCallback(diag->widget(),XmNokCallback,(p_msg)&exit);
   diag->manage();
}


char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL) {
      s++;
   }
   else {
      s = name;
   }	
   return s;
}
