/* $Id: xgauge.C,v 1.2 1999/11/06 05:50:56 glgay Exp $ */
/*
 * Copyright (c) 1998, Phil Grim
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/MessageB.h>
#include <Xarm/PushB.h>
#include <Xmext/Gauge.h>
#include "xgauge.h"

int main (int argc, char **argv)
{
   // initialize application 
   GaugeDemo app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

GaugeDemo::GaugeDemo(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(),proto,(p_msg)&onExit);

   title(app_class);

   // install window(s) into the application window 


   Form *main_form = new Form(app_class, widget());

   XarmArg args;
   args(XmNorientation,     XmHORIZONTAL    )
       (XmNtopAttachment,   XmATTACH_FORM   )
       (XmNleftAttachment,  XmATTACH_FORM   )
       (XmNrightAttachment, XmATTACH_FORM   )
       (XmNtickIncrement,   1               )
       (XmNshowPercentage,  True            )
       (XmNshowMinMax,      False           )
       (XmNminimum,         0               )
       (XmNmaximum,         100             )
       (XmNgaugeMargin,     0               )
       (XmNheight,          35              )
       (XmNshowValue,       True            )
       (XmNforeground, XmRString, "white", 6);
     
   meter1 = new Gauge(*main_form, args, app_class);
   args.reset();

   pixmap = XCreatePixmapFromBitmapData(this->display(), 
                               RootWindow(this->display(), 0),
                               miniweave_tile_bits, miniweave_tile_width,
                               miniweave_tile_height,
                               BlackPixel(this->display(), 0),
                               WhitePixel(this->display(), 0),
                               DefaultDepth(this->display(), 0));
   args(XmNorientation,     XmHORIZONTAL    )
       (XmNtopAttachment,   XmATTACH_WIDGET )
       (XmNleftAttachment,  XmATTACH_FORM   )
       (XmNrightAttachment, XmATTACH_FORM   )
       (XmNtopWidget,       meter1->widget())
       (XmNtickIncrement,   1               )
       (XmNshowMinMax,      True            )
       (XmNminimum,         0               )
       (XmNmaximum,         100             )
       (XmNgaugeMargin,     0               )
       (XmNheight,          45              )
       (XmNshowValue,       False           )
       (XmNsliderPixmap,    pixmap          )
       (XmNforeground, XmRString, "white", 6);
   meter2 = new Gauge(*main_form, args, app_class);
   args.reset();
   
   args(XmNtopAttachment,       XmATTACH_WIDGET    )
       (XmNleftAttachment,      XmATTACH_FORM      )
       (XmNrightAttachment,     XmATTACH_FORM      ) 
       (XmNbottomAttachment,    XmATTACH_FORM      )
       (XmNtopWidget,           meter2->widget()   )
       (XmNprocessingDirection, XmMAX_ON_RIGHT     )
       (XmNminimum,             0                  )
       (XmNmaximum,             100                )
       (XmNvalue,               0                  )
       (XmNorientation,         XmHORIZONTAL       );
 
   scale = new Scale(*main_form, args, "scale");
 
   addCallback(*scale, XmNvalueChangedCallback, (p_msg)&onInc);
   addCallback(*scale, XmNdragCallback, (p_msg)&onInc);

   scale->manage();

   main_form->manage();
}

void GaugeDemo::exit(Widget, XtPointer, XtPointer)
{
   XFreePixmap(this->display(), pixmap);
   quit();
}

void GaugeDemo::onInc(Widget, XtPointer, XtPointer)
{
    meter1->value(scale->value());
    meter2->value(scale->value());
    if (meter1->value() > 30)
        meter1->sliderColor("blue");
    else
        meter1->sliderColor("red");
}
    

void GaugeDemo::onExit(Widget w, XtPointer, XtPointer)
{
   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");

   diag->dialogTitle("Exit Dialog");
   addCallback(diag->widget(),XmNokCallback,(p_msg)&exit);
   diag->manage();
}


char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL) {
      s++;
   }
   else {
      s = name;
   }	
   return s;
}
