/* $Id: main.C,v 1.3 1999/11/06 05:50:56 glgay Exp $ */
/*
 * Copyright (c) 1994, Jettero Heller
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/Label.h>
#include <Xarm/MessageB.h>

/* Declaration(s) */
class Application: public AppContext
{
 private:
   void exit(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);
  
 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *title = "Label example";

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }	
   return s;
}

int
main (int argc, char **argv)
{
   // initialize application 
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(), proto, (p_msg)&Application::onExit);

   title(::title);

   // install window(s) into the application window 
   new Label(*this, "Hello World");
}

void
Application::exit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   quit();
}

void 
Application::onExit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");
   addCallback(diag->widget(), XmNokCallback,(p_msg)&Application::exit);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}

