/* $Id: main.C,v 1.4 1999/11/06 05:50:56 glgay Exp $ */
/*
 * Copyright (c) 1994, Jettero Heller
 * 
 * You may distribute this source code under the terms of the license
 * in the COPYING file.
 * 
 */

/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/MainW.h>
#include <Xarm/MenuB.h>
#include <Xarm/MessageB.h>
#include <Xarm/PushB.h>
#include <Xarm/Separator.h>

/* Declaration(s) */
class Application: public AppContext
{
 private:
   void exit(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);
 
 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }	
   return s;
}

int
main (int argc, char **argv)
{
   // initialize application 
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop 
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(),proto,(p_msg)&Application::onExit);

   title(app_class);

   // install window(s) into the application window 
   MainWindow *win = new MainWindow(*this,(unsigned char)XmAPPLICATION_DEFINED);

   MenuBar *menu= new MenuBar(*win);

   MenuButton *fileB = new MenuButton(*menu, "File", (KeySym) 'F');

   new PushButton(*fileB, "New", (KeySym) 'N');

   new PushButton(*fileB, "Open", (KeySym) 'O');

   new PushButton(*fileB, "Close", (KeySym) 'C');
  
   new Separator(*fileB);
   
   PushButton *quitB = new PushButton(*fileB, "Exit", (KeySym) 'x',
                                      "Alt<Key>X","Alt-X");
   addCallback(*quitB, XmNactivateCallback,(p_msg) &Application::onExit);

   MenuButton *optionB = new MenuButton(*menu, "Options", (KeySym) 'O');

   MenuButton *fonts = new MenuButton(*optionB, "Fonts");
   
   new PushButton(*fonts, "Default");
   new PushButton(*fonts, "Tiny");
   new PushButton(*fonts, "Small");
   new PushButton(*fonts, "Medium");
   new PushButton(*fonts, "Large");
   new PushButton(*fonts, "Huge");

   MenuButton *helpB = new MenuButton(*menu, "Help", (KeySym) 'H');
   
   new PushButton(*helpB, "Index");
   new PushButton(*helpB, "Context");
   new PushButton(*helpB, "About");

   menu->help(*(helpB->button));
   menu->manage();
   win->setArea(*menu,NULL,NULL,NULL,NULL);
   win->manage();
}

void
Application::exit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   quit();
}

void 
Application::onExit(Widget w, XtPointer udata, XtPointer cdata)
{
   w = w;
   cdata = cdata;
   udata = udata;

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");

   addCallback(diag->widget(), XmNokCallback, (p_msg)&Application::exit);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}

