/* $Id: xrun.h,v 1.2 1999/11/06 05:50:57 glgay Exp $ */
/*
 Copyright (C) 1995, 1996 Peter Williams
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#if !defined(_XRUN_H_)
#define _XRUN_H_

#include <Xarm/AppContext.h>
#include <Xarm/FileSB.h>
#include <Xarm/PushB.h>
#include <Xarm/TextF.h>

class RunDialog: public BulletinBoard 
{
 private:
   // internal callback handlers 
   void Browse(Widget, XtPointer, XtPointer);
   void Cancel(Widget, XtPointer, XtPointer);
   void Ok(Widget, XtPointer, XtPointer);
   void SetEntry(Widget, XtPointer, XtPointer);

   // execute routines
   int execute(char *cmd);
   int execute(char *path, char **args);
   int execute_and_wait(char *path, char **args);

   // private data members
   FileSelectionDialog *p_fsdlg;
   TextField *p_entry;
   PushButton *p_browse, *p_cancel, *p_ok;
   char *program_shell;
 public:
   RunDialog(Widget parent, ArgList arglist = NULL, Cardinal cnt = 0);  
   RunDialog(_XtString name, Widget parent);

   // resources
   char *shell() { return program_shell; }
   void shell(char *str) { program_shell = str; }
};

class Application: public AppContext
{
 private:
   // internal callback handlers 
   void Quit(Widget,XtPointer,XtPointer);

   // private objects
   RunDialog *p_rundlg;

 public:
   // application resources
   char *resource_file;
   Boolean show_usage;
   Boolean show_version;
   char *program_shell;

 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);

   static char *basename(char *);
   void get_resources();
   void process_resources();
   void syntax(int opt_no, char **opts);
   void generate_resource_file(char *);
   void usage();
   void version();

   char *shell() { return program_shell; }
}; 

#endif 

