/* $Id: Gadget.h,v 1.4 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_gadget_h)
#define xarm_gadget_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/RectObj.h>

class GadgetClass : public _RectObjClass {
 protected:
   GadgetClass() {} /* only a derived class can make this */
 public:
   /* callbacks */
   void helpCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNhelpCallback); }

   /* resources */
   Pixel bottomShadowColor() const             { XARM_GET_VALUE(Pixel, XmNbottomShadowColor); }
   Pixel highlightColor() const                { XARM_GET_VALUE(Pixel, XmNhighlightColor); }
   void highlightOnEnter(Boolean val)          { XARM_SET_VALUE(XmNhighlightOnEnter); }
   Boolean highlightOnEnter() const            { XARM_GET_VALUE(Boolean, XmNhighlightOnEnter); }
   void highlightThickness(Dimension val)      { XARM_SET_VALUE(XmNhighlightThickness); }
   Dimension highlightThickness() const        { XARM_GET_VALUE(Dimension, XmNhighlightThickness); }
   void navigationType(XmNavigationType val)   { XARM_SET_VALUE(XmNnavigationType); }
   XmNavigationType navigationType() const     { XARM_GET_VALUE(XmNavigationType, XmNnavigationType); }
   void shadowThickness(Dimension val)         { XARM_SET_VALUE(XmNshadowThickness); }
   Dimension shadowThickness() const           { XARM_GET_VALUE(Dimension, XmNshadowThickness); }
   Pixel topShadowColor() const                { XARM_GET_VALUE(Pixel, XmNtopShadowColor); }
   void traversalOn(Boolean val)               { XARM_SET_VALUE(XmNtraversalOn); }
   Boolean traversalOn() const                 { XARM_GET_VALUE(Boolean, XmNtraversalOn); }
   void unitType(unsigned char val)            { XARM_SET_VALUE(XmNunitType); }
   unsigned char unitType() const              { XARM_GET_VALUE(unsigned char, XmNunitType); }
   void userData(XtPointer val)                { XARM_SET_VALUE(XmNuserData); }
   XtPointer userData() const                  { XARM_GET_VALUE(XtPointer, XmNuserData); }
};

#endif
