/* $Id: MessageB.h,v 1.6 1999/11/06 05:50:58 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_messageb_h)
#define xarm_messageb_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class MessageBoxClass : public BulletinBoardClass {
 protected:
   MessageBoxClass() {}
   virtual WidgetClass classPointer() { return xmMessageBoxWidgetClass; }
   virtual _XtString className()      { return (_XtString) "XmMessageBox"; }
 public:
   /* convenience rountines */
   Widget getChild(unsigned char child)       { return XmMessageBoxGetChild(widget(), child); }

   /* callbacks */
   void cancelCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNcancelCallback); }
   void okCallback(XtCallbackProc fp, XtPointer data = NULL)
         { XARM_SET_CALLBACK(XmNokCallback); }

   /* resources */
   void cancelLabelString(const char *str)    { XARM_SET_STRING(XmNcancelLabelString); }
   char *cancelLabelString() const            { XARM_GET_STRING(XmNcancelLabelString); }
   void helpLabelString(const char *str)      { XARM_SET_STRING(XmNhelpLabelString); }
   char *helpLabelString() const              { XARM_GET_STRING(XmNhelpLabelString); }
   void defaultButtonType(unsigned char val)  { XARM_SET_VALUE(XmNdefaultButtonType); }
   unsigned char defaultButtonType() const    { XARM_GET_VALUE(unsigned char, XmNdefaultButtonType); }
   void dialogType(unsigned char val)         { XARM_SET_VALUE(XmNdialogType); }
   unsigned char dialogType() const           { XARM_GET_VALUE(unsigned char, XmNdialogType); }
   void messageAlignment(unsigned char val)   { XARM_SET_VALUE(XmNmessageAlignment); }
   unsigned char messageAlignment() const     { XARM_GET_VALUE(unsigned char, XmNmessageAlignment); }
   void messageString(const char *str)        { XARM_SET_STRING(XmNmessageString); }
   char * messageString() const               { XARM_GET_STRING(XmNmessageString); }
   void minimizeButtons(Boolean val)          { XARM_SET_VALUE(XmNminimizeButtons); }
   Boolean minimizeButtons() const            { XARM_GET_VALUE(Boolean, XmNminimizeButtons); }
   void okLabelString(const char *str)        { XARM_SET_STRING(XmNokLabelString); }
   char *okLabelString() const                { XARM_GET_STRING(XmNokLabelString); }
   void symbolPixmap(Pixmap val)              { XARM_SET_VALUE(XmNsymbolPixmap); }
   Pixmap symbolPixmap() const                { XARM_GET_VALUE(Pixmap, XmNsymbolPixmap); }
};

typedef XarmMessageWidget<MessageBoxClass, XmCreateMessageBox>        MessageBox;
typedef XarmMessageWidget<MessageBoxClass, XmCreateMessageDialog>     MessageDialog;
typedef XarmMessageWidget<MessageBoxClass, XmCreateQuestionDialog>    QuestionDialog;
typedef XarmMessageWidget<MessageBoxClass, XmCreateInformationDialog> InformationDialog;
typedef XarmMessageWidget<MessageBoxClass, XmCreateErrorDialog>       ErrorDialog;
typedef XarmMessageWidget<MessageBoxClass, XmCreateWarningDialog>     WarningDialog;
typedef XarmMessageWidget<MessageBoxClass, XmCreateWorkingDialog>     WorkingDialog;

#endif
