/* $Id: PanedW.h,v 1.5 1999/11/06 05:50:59 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_panedw_h)
#define xarm_panedw_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>

class PanedWindowClass : public ManagerClass {
 protected:
   PanedWindowClass() {}
   virtual WidgetClass classPointer() { return xmPanedWindowWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmPanedWindow"; }
 public:
   /* resources */
   void marginHeight(Dimension val)          { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const            { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)           { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const             { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void refigureMode(Boolean val)            { XARM_SET_VALUE(XmNrefigureMode); }
   Boolean refigureMode() const              { XARM_GET_VALUE(Boolean, XmNrefigureMode); }
   void sashHeight(Dimension val)            { XARM_SET_VALUE(XmNsashHeight); }
   Dimension sashHeight() const              { XARM_GET_VALUE(Dimension, XmNsashHeight); }
   void sashIndent(Position val)             { XARM_SET_VALUE(XmNsashIndent); }
   Position sashIndent() const               { XARM_GET_VALUE(Position, XmNsashIndent); }
   void sashShadowThickness(Dimension val)   { XARM_SET_VALUE(XmNsashShadowThickness); }
   Dimension sashShadowThickness() const     { XARM_GET_VALUE(Dimension, XmNsashShadowThickness); }
   void sashWidth(Dimension val)             { XARM_SET_VALUE(XmNsashWidth); }
   Dimension sashWidth() const               { XARM_GET_VALUE(Dimension, XmNsashWidth); }
   void separatorOn(Boolean val)             { XARM_SET_VALUE(XmNseparatorOn); }
   Boolean separatorOn() const               { XARM_GET_VALUE(Boolean, XmNseparatorOn); }
   void spacing(Dimension val)               { XARM_SET_VALUE(XmNspacing); }
   Dimension spacing() const                 { XARM_GET_VALUE(Dimension, XmNspacing); }
   
};

typedef XarmRawWidget<PanedWindowClass, false> PanedWindow;

#endif
