/* $Id: PushB.h,v 1.6 1999/11/06 05:50:59 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_pushb_h)
#define xarm_pushb_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Label.h>

class PushButtonClass : public LabelClass {
 protected:
   PushButtonClass() {} /* only a derived class can make this */

   virtual WidgetClass classPointer() { return xmPushButtonWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmPushButton"; }
 public:
   /* callbacks */
   void activateCallback(XtCallbackProc fp, XtPointer data = NULL)   { XARM_SET_CALLBACK(XmNactivateCallback); }
   void armCallback(XtCallbackProc fp, XtPointer data = NULL)        { XARM_SET_CALLBACK(XmNarmCallback); }
   void disarmCallback(XtCallbackProc fp, XtPointer data = NULL)     { XARM_SET_CALLBACK(XmNdisarmCallback); }

   /* resources */
   void armColor(Pixel val)                           { XARM_SET_VALUE(XmNarmColor); }
   Pixel armColor() const                             { XARM_GET_VALUE(Pixel, XmNarmColor); }
   void armPixmap(Pixmap val)                         { XARM_SET_VALUE(XmNarmPixmap); }
   Pixmap armPixmap() const                           { XARM_GET_VALUE(Pixmap, XmNarmPixmap); }
   void defaultButtonShadowThickness(Dimension val)   { XARM_SET_VALUE(XmNdefaultButtonShadowThickness); }
   Dimension defaultButtonShadowThickness() const     { XARM_GET_VALUE(Dimension, XmNdefaultButtonShadowThickness); }
   void fillOnArm(Boolean val)                        { XARM_SET_VALUE(XmNfillOnArm); }
   Boolean fillOnArm() const                          { XARM_GET_VALUE(Boolean, XmNfillOnArm); }
   void multiClick(unsigned char val)                 { XARM_SET_VALUE(XmNmultiClick); }
   unsigned char multiClick() const                   { XARM_GET_VALUE(unsigned char, XmNmultiClick); }
   void showAsDefault(Dimension val)                  { XARM_SET_VALUE(XmNshowAsDefault); }
   Dimension showAsDefault() const                    { XARM_GET_VALUE(Dimension, XmNshowAsDefault); }

   /* extra functionality */
   void autoSpace(int size = 100);
   void armColor(const char *val)                     { XARM_SET_TYPED(XmNarmColor); }
};

////////////////////////////////////////////
//                                        //
// PushButton is not a typedef because it //
// has a non-standard constructor!        //
//                                        //
////////////////////////////////////////////

class PushButton : public PushButtonClass {
 public:
   PushButton(Widget w_parent, 
                char *text, 
                KeySym mn = 0,
                _XtString acc = NULL, 
                char *acc_text = NULL,
                _XtString name = NULL);

   PushButton(Widget w_parent, 
              ArgList arglist = NULL, 
              Cardinal cnt = 0,
              _XtString name = NULL);

   PushButton(_XtString name, Widget w_parent);
   PushButton(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
