/* $Id: SelectioB.h,v 1.5 1999/11/06 05:50:59 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_selectiob_h)
#define xarm_selectiob_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/BulletinB.h>

class SelectionBoxClass : public BulletinBoardClass {
 protected:
   SelectionBoxClass() {}
   virtual WidgetClass classPointer()  { return xmSelectionBoxWidgetClass; }
   virtual _XtString className()       { return (_XtString) "XmSelectionBox"; }

 public:
   /* callbacks */
   void applyCallback(XtCallbackProc fp, XtPointer data = NULL)    { XARM_SET_CALLBACK(XmNapplyCallback); }
   void cancelCallback(XtCallbackProc fp, XtPointer data = NULL)   { XARM_SET_CALLBACK(XmNcancelCallback); }
   void noMatchCallback(XtCallbackProc fp, XtPointer data = NULL)  { XARM_SET_CALLBACK(XmNnoMatchCallback); }
   void okCallback(XtCallbackProc fp, XtPointer data = NULL)       { XARM_SET_CALLBACK(XmNokCallback); }

   /* convenience routines */
   virtual Widget getChild(unsigned char child) { return XmSelectionBoxGetChild(widget(), child); }

   /* resources */
   void applyLabelString(const char *str)      { XARM_SET_STRING(XmNapplyLabelString); }
   char *applyLabelString() const              { XARM_GET_STRING(XmNapplyLabelString); }
   void cancelLabelString(const char *str)     { XARM_SET_STRING(XmNcancelLabelString); }
   char *cancelLabelString() const             { XARM_GET_STRING(XmNcancelLabelString); }
   void childPlacement(unsigned char val)      { XARM_SET_VALUE(XmNchildPlacement); }
   unsigned char childPlacement() const        { XARM_GET_VALUE(unsigned char, XmNchildPlacement); }
   void dialogType(unsigned char val)          { XARM_SET_VALUE(XmNdialogType); }
   unsigned char dialogType() const            { XARM_GET_VALUE(unsigned char, XmNdialogType); }
   void helpLabelString(const char *str)       { XARM_SET_STRING(XmNhelpLabelString); }
   char *helpLabelString() const               { XARM_GET_STRING(XmNhelpLabelString); }
   void listItemCount(int val)                 { XARM_SET_VALUE(XmNlistItemCount); }
   int listItemCount() const                   { XARM_GET_VALUE(int, XmNlistItemCount); }
   void listItems(const XmStringTable val)     { XARM_SET_VALUE(XmNlistItems); }
   XmStringTable listItems() const             { XARM_GET_VALUE(XmStringTable, XmNlistItems); }
   void listLabelString(const char *str)       { XARM_SET_STRING(XmNlistLabelString); }
   char *listLabelString() const               { XARM_GET_STRING(XmNlistLabelString); }
   void listVisibleItemCount(int val)          { XARM_SET_VALUE(XmNlistVisibleItemCount); }
   int listVisibleItemCount() const            { XARM_GET_VALUE(int, XmNlistVisibleItemCount); }
   void minimizeButtons(Boolean val)           { XARM_SET_VALUE(XmNminimizeButtons); }
   Boolean minimizeButtons() const             { XARM_GET_VALUE(Boolean, XmNminimizeButtons); }
   void mustMatch(Boolean val)                 { XARM_SET_VALUE(XmNmustMatch); }
   Boolean mustMatch() const                   { XARM_GET_VALUE(Boolean, XmNmustMatch); }
   void okLabelString(const char *str)         { XARM_SET_STRING(XmNokLabelString); }
   char *okLabelString() const                 { XARM_GET_STRING(XmNokLabelString); }
   void selectionLabelString(const char *str)  { XARM_SET_STRING(XmNselectionLabelString); }
   char *selectionLabelString() const          { XARM_GET_STRING(XmNselectionLabelString); }
   void textColumns(short val)                 { XARM_SET_VALUE(XmNtextColumns); }
   short textColumns() const                   { XARM_GET_VALUE(short, XmNtextColumns); }
   void textString(const char *str)            { XARM_SET_STRING(XmNtextString); }
   char *textString() const                    { XARM_GET_STRING(XmNtextString); }
};

typedef XarmFuncWidget<SelectionBoxClass, XmCreateSelectionBox,    false> SelectionBox;
typedef XarmFuncWidget<SelectionBoxClass, XmCreateSelectionDialog, false> SelectionDialog;

////////////////////////////////////////////
//                                        //
// PromptDialog is not a template because //
// it has non-standard constructors!      //
//                                        //
////////////////////////////////////////////

class PromptDialog : public SelectionBoxClass {
 protected:
   virtual Widget createWidget(_XtString name,
                               Widget w_parent,
                               ArgList arglist = NULL,
                               Cardinal cnt = 0);
 public:
   PromptDialog(Widget w_parent, char *mesg, _XtString name = NULL);
   PromptDialog(Widget w_parent,
                ArgList arglist = NULL,
                Cardinal cnt = 0,
                _XtString name = NULL);
   PromptDialog(_XtString name, Widget w_parent);
   PromptDialog(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
