#ifndef _XmGaugeP_h
#define _XmGaugeP_h

#include <Xmext/Gauge.h>
#if XmVersion == 1001
#include <Xm/XmP.h>
#else
#include <Xm/PrimitiveP.h>
#endif

#define XmRGaugeStyle "RGaugeStyle"

/*  Minimum slider width or height  */

#define MIN_SLIDER_THICKNESS 4
#define MIN_SLIDER_LENGTH	6

/*  Arrow class structure  */

typedef struct _XmGaugeClassPart
{
   caddr_t extension;
} XmGaugeClassPart;


/*  Full class record declaration for Gauge class  */

typedef struct _XmGaugeClassRec
{
   CoreClassPart        	core_class;
   XmPrimitiveClassPart 	primitive_class;
   XmGaugeClassPart     	gauge_class;
} XmGaugeClassRec;

externalref XmGaugeClassRec xmGaugeClassRec;


typedef struct _ColorThreshold
{
	Pixel			 		  color;
	char					 *color_name;
	int				 		  value;
	struct _ColorThreshold  *next;
} *ColorThreshold;


/*  The Gauge instance record  */

typedef struct _XmGaugePart
{
	/* resources */

    XmFontList fontlist;
    Pixel          trough_color;
    Pixel          slider_color;
    int	           slider_size;
    int            tick_increment;
    int            minimum;
    int            maximum;
    int            value;
    int            gauge_margin;
    int            trough_shadow_thickness;
    int            slider_shadow_thickness;
    unsigned char  orientation;
    unsigned char  processing_direction;
    Boolean        fill;
    Boolean        show_value;
    Boolean        show_min_max;
    Boolean        show_percentage;
    Pixmap         slider_pixmap;
    ColorThreshold color_thresholds;


    /* Private state */

    GC         foreground_GC;	
    GC         background_GC;
    GC         text_GC;
    GC         text_erase_GC;
    GC         slider_GC;

    XFontStruct *font;
    Drawable   pixmap;
    int        prev_value;
    int        percentage;
    int        prev_percentage;
    short slider_x;
    short slider_y;
    short slider_width;
    short slider_height;

    short slider_area_x;
    short slider_area_y;
    short slider_area_width;
    short slider_area_height;

    short minimum_x;
    short minimum_y;
    short maximum_x;
    short maximum_y;
    short value_x;
    short value_y;

} XmGaugePart;


/*  Full instance record declaration  */

typedef struct _XmGaugeRec
{
   CorePart	    core;
   XmPrimitivePart  primitive;
   XmGaugePart      gauge;
} XmGaugeRec;


#endif /* _XmGaugeP_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */
