/* $Id: Property.h,v 1.2 1999/11/06 05:51:00 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994-1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XM_PROPERTY_H_)
#define _XM_PROPERTY_H_

#include <Xm/BulletinB.h>

#if defined(__cplusplus)
extern "C" {
#endif

/* ======================================================================== */
/* PropertySheet Widget */

extern WidgetClass xmPropertySheetWidgetClass;
typedef struct _XmPropertySheetRec *XmPropertySheetWidget;
typedef struct _XmPropertySheetClassRec *XmPropertySheetWidgetClass;

#define XmIsPropertySheet(w) XtIsSubclass((w), xmPropertySheetWidgetClass)

Widget XmCreatePropertySheet(Widget parent,  
                             char *name, 
                             Arg *arglist, 
                             Cardinal argcount);

Widget XmCreatePropertySheetDialog(Widget parent,  
                             char *name, 
                             Arg *arglist, 
                             Cardinal argcount);

/*
 * child is one of these (defined in Xm.h) 
 * XmDIALOG_APPLY_BUTTON, 
 * XmDIALOG_CANCEL_BUTTON, 
 * XmDIALOG_OK_BUTTON 
 * XmDIALOG_HELP_BUTTON 
 */
Widget XmPropertySheetGetChild(Widget widget, unsigned char child);

Widget XmPropertySheetGetPage(Widget sheet, int position);
void XmPropertySheetAddPage(Widget sheet, Widget page, int position);
void XmPropertySheetRemovePos(Widget sheet, int position);
void XmPropertySheetRemovePage(Widget sheet, Widget page);

/* new resource definitions */                      
#define XmNactivePos "activePos"                  
#define XmNpageCount "pageCount"                 
#define XmNpages "pages"
#define XmNtabs "tabs" 

/* new resource class definitions */
#define XmCActivePos "ActivePos"
#define XmCPageCount "PageCount"
#define XmCPages "Pages"
#define XmCTabs "Tabs"

#if 0
/* Property Sheet Resource Set */
Name                  Class                 Type             Default     Access
--------------------------------------------------------------------------------
XmNactivePos          XmCActivePos          int              0           CSG
XmNapplyLabelString   XmCApplyLabelString   XmString         dynamic     CSG
XmNapplyCallback      XmCCallback           XtCallbackList   NULL        C
XmNcancelLabelString  XmCCancelLabelString  XmString         dynamic     CSG
XmNcancelCallback     XmCCallback           XtCallbackList   NULL        C
XmNhelpLabelString    XmCHelpLabelString    XmString         dynamic     CSG
XmNokLabelString      XmCOkLabelString      XmString         dynamic     CSG
XmNokCallback         XmCCallback           XtCallbackList   NULL        C
XmNpageCount          XmCPageCount          int              0             G
XmNpages              XmCPages              WidgetList       NULL          G
XmNtabs               XmCTabs               WidgetList       NULL          G

/* Overridden Inherited Resources */
/* None */

#endif

#if defined(__cplusplus)
}
#endif

#endif

