/* $Id: TabP.h,v 1.2 1999/11/06 05:51:00 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XM_TABP_H_)
#define _XM_TABP_H_

#include <Xm/XmP.h>
#include <Xmext/Tab.h>
#include <Xm/LabelP.h>

#if defined(__cplusplus)
extern "C" {
#endif

/* ======================================================================== */
/* Tab Widget */
/* Define the tab's instance part */
typedef struct {
   Pixel arm_color;
   Pixmap arm_pixmap;
   Boolean fill_on_arm;
   XtCallbackList activate_callback;
   XtCallbackList arm_callback;
   XtCallbackList disarm_callback;

   Boolean show_as_active;
   int corner_style;
   int corner_size;

   Boolean armed;
   Pixmap unarm_pixmap;
   GC fill_gc;
   GC background_gc;

} XmTabPart;

/* Define the full instance record */
typedef struct _XmTabRec {
   /* inherit from the following */
   CorePart core;
   XmPrimitivePart primitive;
   XmLabelPart label;
   /* self */
   XmTabPart tab;
} XmTabRec;
   
/* Define class part structure */
typedef struct {
   XtPointer extension;
} XmTabClassPart;

/* Define the full class record */
typedef struct _XmTabClassRec {
   CoreClassPart core_class;
   XmPrimitiveClassPart primitive_class;
   XmLabelClassPart label_class;
   XmTabClassPart tab_class;
} XmTabClassRec;

extern XmTabClassRec xmTabClassRec;

#define Tab_ActivateCallback(w) \
        (((XmTabWidget) (w))->tab.activate_callback)

#define Tab_ArmCallback(w) \
        (((XmTabWidget) (w))->tab.arm_callback)

#define Tab_ArmColor(w) \
        (((XmTabWidget) (w))->tab.arm_color)
        
#define Tab_Armed(w) \
        (((XmTabWidget) (w))->tab.armed)

#define Tab_ArmPixmap(w) \
        (((XmTabWidget) (w))->tab.arm_pixmap)

#define Tab_BackgroundGC(w) \
        (((XmTabWidget) (w))->tab.background_gc)
        
#define Tab_CornerStyle(w) \
        (((XmTabWidget) (w))->tab.corner_style)

#define Tab_CornerSize(w) \
        (((XmTabWidget) (w))->tab.corner_size)

#define Tab_DisarmCallback(w) \
        (((XmTabWidget) (w))->tab.disarm_callback)

#define Tab_FillGC(w) \
        (((XmTabWidget) (w))->tab.fill_gc)

#define Tab_FillOnArm(w) \
        (((XmTabWidget) (w))->tab.fill_on_arm)

#define Tab_ShowAsActive(w) \
        (((XmTabWidget) (w))->tab.show_as_active)

#define Tab_UnarmPixmap(w) \
        (((XmTabWidget) (w))->tab.unarm_pixmap)

#if defined(__cplusplus)
};
#endif

#endif
