/* $Id: AppContext.C,v 1.5 1999/11/06 05:51:00 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1998, 1999 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

/* Include(s): */
#include <stdlib.h>
#include <Xarm/AppContext.h>

/* AppContext */

/*
*  AppContext\(\)
*
*  The classes constructor.
*/
AppContext::AppContext(const char *app_class, 
                       XrmOptionDescList options, 
                       Cardinal no, 
                       int &argc_in_out, 
                       char **argv_in_out, 
                       _XtString *fallbacks)
{
   XtAppContext ac;
   Widget wid = XtVaAppInitialize(
      &ac,                      /* application context */
      app_class,                /* application class */
      options, no,              /* command line option list */
      &argc_in_out, argv_in_out,/* command line args */
      fallbacks,                /* for missing app-defaults file */
      NULL);                    /* terminate varags list */

   widget(wid);
   appContext(ac);

   /* install extra resource converters */
   registerConverters();

#if 0

   /* add my hooks */
   XtActionsRec actions[1];

   /* this is so mnemonics work out of menu's */
   actions[0].string = "activate";
   actions[0].proc = (XtActionProc) AppContext::activate; 

   addActions(actions, 1);

#endif

}

#if 0

void 
AppContext::activate(Widget w, XEvent *event, _XtString *s, unsigned int *num) {
   Widget child;
   num = num;
   w = w;

   /* >>>>>>>>>>> this is system dependent */
   /* use sizeof(ptrdiff_t) (?) & sprintf to form a format string to make this 
      system independent */
   sscanf(s[0],"%lu", (unsigned long) &child);

   XtCallCallbacks(child,XmNactivateCallback, (char *) event);
}

#endif


/* AppContextClass member functions */

/*
* mainLoop\(\)
*
* This is the main loop
*
*/
void
AppContextClass::mainLoop()
{
   XEvent ev;
   doneProcessing = false;

   while (!doneProcessing) {
       nextEvent(&ev);
       dispatchEvent(&ev);
   }

   // If there are any leftover events
   // then process them...

   while (pending()) {
       nextEvent(&ev);
       dispatchEvent(&ev);
   }
}

/*
* quit\(\)
*
* This is used to exit the application
*/
void
AppContextClass::quit(bool now)
{
   if (now) {
       exit(EXIT_SUCCESS);
   } else {
       doneProcessing = true;
   }
}
