/* $Id: SelectioB.C,v 1.6 1999/11/06 05:51:01 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/SelectioB.h>

Widget
PromptDialog::createWidget(_XtString name,
                              Widget w_parent,
                              ArgList arglist,
                              Cardinal cnt)
{
   if(name == NULL || *name == '\0') { name = className(); }
   return XmCreatePromptDialog(w_parent, name, arglist, cnt);
}

PromptDialog::PromptDialog(Widget w_parent, char *mesg, _XtString name)
{
   Widget w = createWidget(name, w_parent);
   widget(w);
   selectionLabelString(mesg);
}

PromptDialog::PromptDialog(Widget w_parent,
                           ArgList arglist,
                           Cardinal cnt,
                           _XtString name)
{
   Widget w = createWidget(name, w_parent, arglist, cnt); 
   widget(w);
}

PromptDialog::PromptDialog(Widget w_parent, XarmArg &args, _XtString name)
{
   Widget w = createWidget(name, w_parent, args.getArgs(), args.count());
   if (args.hasTypedArgs()) args.setTypedArgs(w);
   widget(w);
}

PromptDialog::PromptDialog(_XtString name, Widget w_parent)
{
   Widget w = createWidget(name, w_parent); 
   widget(w);
}

