#include <unistd.h>

#include <Xclasses/Xwindows.h>
#include <Xclasses/group.h>
#include <Xclasses/bordergroup.h>
#include <Xclasses/xclock.h>
#include <Xclasses/button.h>
#include <Xclasses/selbutton.h>
#include <Xclasses/indicator.h>
#include <Xclasses/input.h>
#include <Xclasses/ruler.h>
#include <Xclasses/tools.h>

Xcolors d;
Xwindows w;
XEvent myevent;
int v;
char itxt[10];

group g1,*g;
bordergroup lk,dg;
xclock b1,b2,b3,b4;
button ende,tb1,tb2,tb3,tb4;
selbutton lock1,lock2;
indicator i1,i2;
input ip1,ip2;
ruler hr1,hr2,hr3;

#define GGFONT	FONT_GADGET
#define GPFONT	FONT_GROUP

int main(int argc,char *argv[])
{
	int r,c;
	XEvent myevent;

	if (!d.Init(argc,argv))
	{
		printf("Error:\nCan't open display\n\n");
		exit(1);
	}

	w.Title("Mein Fenster");
	w.Create(0,0,300,300);	
	w.Geometry(argc,argv);
	w.IconTitle("Mein Icon");
	w.Background(d.col_background());
	
	g1.Background(0xa0a0,0xa0a0,0xc0c0);
	g1.Vert();
	g1.Font(GPFONT);
	g=g1.Add();
	g->Horiz();
	g->Font(GPFONT);
	g->Add(b1);
	g->Add(b2);
	g->Add(b3);
	g->Add(b4);
	g1.Add(hr2);

	g=g1.Add();
	g->Horiz();
	g->Font(GPFONT);
	g->Add(i1);
	g->Add(hr3);
	g->Add(i2);

	g1.Add(hr1);
	g=g1.Add();
	g->Font(GPFONT);
	g->Add(ip1);
	g->Add(ip2);

	g1.Add(lk);
	lk.Font(GPFONT);
	lk.Horiz();
	lk.Title("Lock");
	lk.Add(lock1);
	lk.Add(lock2);

	g1.Add(dg);
	dg.Font(GPFONT);
	dg.DialogMode();
	dg.Title("Dialog");
	dg.Horiz();
	dg.Add(tb1);
	tb1.Text("Ja!");
	tb1.Font(GGFONT);
	dg.Add(tb2);
	tb2.Text("Vielleicht");
	tb2.Font(GGFONT);
	dg.Add(tb3);
	tb3.Text("Hilfe, was??");
	tb3.Font(GGFONT);
	dg.Add(tb4);
	tb4.Text("Nein, auf keinen Fall");
	tb4.Font(GGFONT);


	g1.Add(ende);
	ip1.Text("erstes Eingabe:");
	ip1.Default("Feld 1");
	ip1.Font(GGFONT);
	ip1.MaxChars(40);
    ip1.ID(4);
	ip2.Text("zweites Eingabe:");
	ip2.Default("Text Feld 2");
	ip2.Font(GGFONT);
	ip2.AlwaysMode();
	lock1.Text("erste Eingabe");
	lock1.State(RELEASED);
	lock1.ID(2);
	lock1.Font(GGFONT);
	lock2.Text("zweite Eingabe");
	lock2.State(RELEASED);
	lock2.ID(3);
	lock2.Font(GGFONT);
	ende.Text("Ende");
	ende.ID(1);
	ende.Font(GGFONT);

	b1.Seconds();
	b2.FormCrazy();
	b2.Seconds();
	b3.Seconds();
	b3.SmallSeconds();
	b3.ExactMinutes();	
	b4.NoMinutes();

	i1.Title("Horiz Indicator");
	i1.MaxValue(500,50);
	i1.Font(GGFONT);
	i2.CircleIndicator();
	i2.Title("Circle");
	i2.MaxValue(500,50);
	i2.Font(GGFONT);
	hr1.Space(5);
	hr2.Space(5);
	hr3.Vert(); hr3.Space(2);

	g1.Create(w.window());	

	w.MinSize(g1.minWidth(),g1.minHeight());
	w.MaxSize(g1.maxWidth(),g1.maxHeight());
	w.MakeFit();

	w.OpenU();
	w.Event(StructureNotifyMask|KeyPressMask);
	v=0; c=0;
	g1.Resize(w.window());
	do
	{
		r=b1.TickEvent(&myevent);
		if (r==0)
		{
			switch (myevent.type)
			{
				case ConfigureNotify:
					g1.Resize(w.window());
					break;
			}
		}
		else if (r==-1)
		{
			if (++c>3)
			{
				c=0;
				v++; if (v>500) v=0;
				sprintf(itxt,"%d - %d %%",v,100*v/500);
				i1.Value(v,itxt);
				i2.Value(v,itxt);
			}
		}
		else if (r==2)
		{
			if (lock1.State()==PRESSED)
			{
				ip1.Lock();
			}
			else
			{
				ip1.Unlock();
			}
		}
		else if (r==3)
		{
			if (lock2.State()==PRESSED)
			{
				ip2.Lock();
			}
			else
			{
				ip2.Unlock();
			}
		}
		else if (r==4)
		{
			char t[41];
			Xclasses *c;
			ip1.Input(t);
			c=FindObject(t);
			printf("%s: %x\n",t,c);
			if (c)
				printf("-- \"%s\"\n",c->FullName());
		}
	}
	while (r!=1 && !w.IsCloseEvent(&myevent));

	w.CloseU();
	g1.Free();
	w.Destroy();
}
